
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "app2h.h"
#include "../utilities/utilities.h"
#include "../utilities/bezpatches.h"
#include "../utilities/linkage.h"
#include "texture.h"
#include "trans.h"
#include "lights.h"
#include "app2hstruct.h"

static const GLfloat mvertpos[4][3] =
  {{1.5,-1.2,-1.0},{1.5,1.2,-1.0},{1.5,1.2,1.0},{1.5,-1.2,1.0}};

void LoadMirrorShaders ( GLuint program_id[2] )
{
  static const char *filename[] =
    { "app2g4.vert.glsl", "app2g3.frag.glsl",
      "app2g2.vert.glsl", "app2g2.frag.glsl" };
  static const GLuint shtype[] =
    { GL_VERTEX_SHADER, GL_FRAGMENT_SHADER, GL_VERTEX_SHADER, GL_FRAGMENT_SHADER };
  GLuint shader_id[4];
  int    i;

  for ( i = 0; i < 4; i++ )
    shader_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  program_id[0] = LinkShaderProgram ( 2, shader_id, "3" );
  program_id[1] = LinkShaderProgram ( 2, &shader_id[2], "4" );
  AttachUniformTransBlockToBP ( program_id[0] );
  AttachUniformTransBlockToBP ( program_id[1] );
  for ( i = 0; i < 4; i++ )
    glDeleteShader ( shader_id[i] );
  ExitIfGLError ( "LoadMirrorShaders" );
} /*LoadMirrorShaders*/

void ConstructMirror ( Mirror *mirror )
{
  GLenum status;

  glGenTextures ( 2, mirror->mirror_txt );
  glBindTexture ( GL_TEXTURE_2D, mirror->mirror_txt[0] );
  glTexParameteri ( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
  glTexParameteri ( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
  glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGB, MIRRORTXT_W, MIRRORTXT_H,
                 0, GL_RGB, GL_UNSIGNED_BYTE, NULL );
  glBindTexture ( GL_TEXTURE_2D, mirror->mirror_txt[1] );
  glTexImage2D ( GL_TEXTURE_2D, 0, GL_DEPTH_COMPONENT, MIRRORTXT_W, MIRRORTXT_H,
                 0, GL_DEPTH_COMPONENT, GL_FLOAT, NULL );
  glGenFramebuffers ( 1, &mirror->mirror_fbo );
  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, mirror->mirror_fbo );
  glFramebufferTexture ( GL_DRAW_FRAMEBUFFER, GL_COLOR_ATTACHMENT0,
                         mirror->mirror_txt[0], 0 );
  glFramebufferTexture ( GL_DRAW_FRAMEBUFFER, GL_DEPTH_ATTACHMENT,
                         mirror->mirror_txt[1], 0 );
  if ( (status = glCheckFramebufferStatus ( GL_DRAW_FRAMEBUFFER )) !=
       GL_FRAMEBUFFER_COMPLETE )
    ExitOnError ( "ConstructMirrorFBO" );
  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, 0 );
  glBindTexture ( GL_TEXTURE_2D, 0 );

  glGenVertexArrays ( 1, &mirror->mirror_vao );
  glBindVertexArray ( mirror->mirror_vao );
  glGenBuffers ( 1, &mirror->mirror_vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, mirror->mirror_vbo );
  glBufferData ( GL_ARRAY_BUFFER,
                 4*3*sizeof(GLfloat), mvertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindVertexArray ( 0 );
  M4x4Identf ( mirror->mirror_matrix );
  ExitIfGLError ( "ConstructMirrorVAO" );
} /*ConstructMirror*/

void SetupMirrorVPMatrices ( GLfloat eyepos[4], GLfloat reyepos[4],
                             GLfloat mvm[16], GLfloat mpm[16] )
{
  GLfloat mfm[16], *v1, *v2, *nv, *p;
  GLfloat s, a[3], b[3];
  int     i;

  v1 = &mfm[0], v2 = &mfm[4], nv = &mfm[8], p = &mfm[12];
  for ( i = 0; i < 3; i++ ) {
    v1[i] = mvertpos[1][i]-mvertpos[0][i];
    v2[i] = mvertpos[3][i]-mvertpos[0][i];
    a[i] = mvertpos[0][i]-eyepos[i];
  }
  V3CrossProductf ( nv, v2, v1 );
  s = sqrt ( V3DotProductf ( nv, nv ) );
  if ( V3DotProductf ( nv, a ) < 0.0 )  
    s = -s;
  nv[0] /= s;  nv[1] /= s;  nv[2] /= s;
  V3ReflectPointf ( reyepos, mvertpos[0], nv, eyepos );
  memcpy ( p, reyepos, 3*sizeof(GLfloat) );
  mfm[3] = mfm[7] = mfm[11] = 0.0;
  mfm[15] = 1.0;
  M4x4Invertf ( mvm, mfm );
  M4x4MultMP3f ( a, mvm, mvertpos[0] );
  M4x4MultMP3f ( b, mvm, mvertpos[2] );
  M4x4Frustumf ( mpm, NULL, a[0], b[0], a[1], b[1], -a[2], 20.0 );
} /*SetupMirrorVPMatrices*/

void DrawMirror ( Mirror *mirror, GLuint program_id, char final )
{
  glBindVertexArray ( mirror->mirror_vao );
  glUseProgram ( program_id );
  if ( final ) {
    glActiveTexture ( GL_TEXTURE1 );
    glBindTexture ( GL_TEXTURE_2D, mirror->mirror_txt[0] );
  }
  glPolygonMode ( GL_FRONT_AND_BACK, GL_FILL );
  glDrawArrays ( GL_TRIANGLE_FAN, 0, 4 );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawMirror" );
} /*DrawMirror*/

void DeleteMirror ( Mirror *mirror )
{
  glDeleteFramebuffers ( 1, &mirror->mirror_fbo );
  glDeleteTextures ( 2, mirror->mirror_txt );
  glDeleteBuffers ( 1, &mirror->mirror_vbo );
  glDeleteVertexArrays ( 1, &mirror->mirror_vao );
  ExitIfGLError ( "DeleteMirror" );
} /*DeleteMirrorVAO*/

