#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h"
#include <GLFW/glfw3.h>

#include "../utilities/utilities.h"
#include "app2d.h"
#include "app2dproc.h"

#define STATE_NOTHING 0
#define STATE_TURNING 1

GLFWwindow  *mywindow;
double      last_xi, last_eta;
int         app_state = STATE_NOTHING;
char        redraw;
static void (*idlefunc)(void) = NULL;
int         opti = 0;

void myGLFWErrorHandler ( int error, const char *description )
{
  fprintf ( stderr, "GLFW error: %s\n", description );
  exit ( 1 );
} /*myGLFWErrorHandler*/

void ReshapeFunc ( GLFWwindow *win, int width, int height )
{
  ResizeMyWorld ( width, height );
  redraw = true;
  opti = 4;
} /*ReshapeFunc*/

void Redraw ( GLFWwindow *win )
{
  if ( opti > 0 ) {
    opti --;
    glfwPostEmptyEvent ();
  }
  else {
    RedrawMyWorld ();
    redraw = false;
  }
  glfwSwapBuffers ( win );
} /*Redraw*/

void DisplayFunc ( GLFWwindow *win )
{
  redraw = true;
} /*DisplayFunc*/

void IdleFunc ( void )
{
  if ( MoveOn () )
    redraw = true;
} /*IdleFunc*/

void SetIdleFunc ( void(*IdleFunc)(void) )
{
  idlefunc = IdleFunc;
} /*SetIdleFunc*/

void KeyFunc ( GLFWwindow *win, int key, int scancode, int action, int mode )
{
  if ( action == GLFW_PRESS || action == GLFW_REPEAT ) {
    switch ( key ) {
  case GLFW_KEY_ESCAPE:
      glfwSetWindowShouldClose ( mywindow, 1 );
      break;
  default:
      break;
    }
  }
} /*KeyFunc*/

void CharFunc ( GLFWwindow *win, unsigned int charcode )
{
  redraw = ProcessCharCommand ( charcode );
} /*CharFunc*/

void MouseFunc ( GLFWwindow *win, int button, int action, int mods )
{
  switch ( app_state ) {
case STATE_NOTHING:
    if ( button == GLFW_MOUSE_BUTTON_LEFT && action == GLFW_PRESS ) {
      glfwGetCursorPos ( win, &last_xi, &last_eta );
      app_state = STATE_TURNING;
    }
    break;
case STATE_TURNING:
    if ( button == GLFW_MOUSE_BUTTON_LEFT && action != GLFW_PRESS )
      app_state = STATE_NOTHING;
    break;
default:
    break;
  }
} /*MouseFunc*/

void MotionFunc ( GLFWwindow *win, double x, double y )
{
  switch ( app_state ) {
case STATE_TURNING:
    if ( x != last_xi || y != last_eta ) {
      RotateViewer ( x-last_xi, y-last_eta );
      last_xi = x,  last_eta = y;
      redraw = true;
    }
    break;
default:
    break;
  }
} /*MotionFunc*/

void Initialise ( int argc, char **argv )
{
  glfwSetErrorCallback ( myGLFWErrorHandler );
  if ( !glfwInit () )
    ExitOnError ( "glfwInit failed" );
  glfwWindowHint ( GLFW_SAMPLES, 8 );
  if ( !(mywindow = glfwCreateWindow ( 480, 360,
                                       "aplikacja 2D", NULL, NULL )) ) {
    glfwTerminate ();
    ExitOnError ( "glfwCreateWindow failed" );
  }
  glfwMakeContextCurrent ( mywindow );
  GetGLProcAddresses ( APP2D_GL_MAJOR, APP2D_GL_MINOR );
  PrintGLVersion ();
  glfwSetFramebufferSizeCallback ( mywindow, ReshapeFunc );
  glfwSetWindowRefreshCallback ( mywindow, DisplayFunc );
  glfwSetKeyCallback ( mywindow, KeyFunc );
  glfwSetCharCallback ( mywindow, CharFunc );
  glfwSetMouseButtonCallback ( mywindow, MouseFunc );
  glfwSetCursorPosCallback ( mywindow, MotionFunc );
  InitMyWorld ( argc, argv, 480, 360 );
  redraw = true;
} /*Initialise*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glfwDestroyWindow ( mywindow );
  glfwTerminate ();
} /*Cleanup*/

void MessageLoop ( void )
{
  do {
    if ( idlefunc ) {
      idlefunc ();
      glfwPollEvents ();
    }
    else
      glfwWaitEvents ();
    if ( redraw )
      Redraw ( mywindow );
  } while ( !glfwWindowShouldClose ( mywindow ) );
} /*MessageLoop*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  SetIdleFunc ( IdleFunc );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/

