
#define MIN_TESS_LEVEL  3
#define MAX_TESS_LEVEL 32

#define ANGULAR_VELOCITY1 (0.25*PI)
#define ANGULAR_VELOCITY2 (-2.0*PI)

typedef struct Camera {
    int    win_width, win_height;
    float  left, right, bottom, top, near, far, rl, tb;
    float  viewer_pos0[4];
    float  viewer_rvec[3];
    double viewer_rangle;
  } Camera;

typedef struct {
    Camera          camera;
    BezierPatchObjf *myteapot, *mytorus;
    TransBl         trans;
    LightBl         light;
    GLint           BezNormals, TessLevel;
    char            cnet, skeleton, animate;
    float           model_rot_axis[3];
    double          teapot_rot_angle, torus_rot_angle;
    GLfloat         teapot_mmatrix[16], torus_mmatrix[16];
    GLuint          program_id[2];
  } AppData;

