#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "trans.h"

#define NTRUOFFS 6

static GLuint  trbbp = GL_INVALID_INDEX;
static GLint   trbsize, trbofs[NTRUOFFS];
static const GLchar *UTBNames[] =
  { "TransBlock", "TransBlock.mm", "TransBlock.mmti", "TransBlock.vm",
    "TransBlock.pm", "TransBlock.vpm", "TransBlock.eyepos" };

GLuint GetAccessToTransBlockUniform ( GLuint program_id )
{
  if ( trbbp == GL_INVALID_INDEX )
    GetAccessToUniformBlock ( program_id, NTRUOFFS, &UTBNames[0],
                              &trbsize, trbofs, &trbbp );
  else
    AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
  return trbbp;
} /*GetAccessToTransBlockUniform*/

GLuint NewUniformTransBlock ( void )
{
  return NewUniformBuffer ( trbsize, trbbp );
} /*NewUniformTransBlock*/

void AttachUniformTransBlockToBP ( GLuint program_id )
{
  AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
} /*AttachUniformTransBlockToBP*/

void LoadVPMatrix ( TransBl *trans )
{
  GLfloat vpm[16];

  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  M4x4Multf ( vpm, trans->pm, trans->vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[2], 16*sizeof(GLfloat), trans->vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[3], 16*sizeof(GLfloat), trans->pm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[4], 16*sizeof(GLfloat), vpm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[5], 4*sizeof(GLfloat), trans->eyepos );
  ExitIfGLError ( "LoadPMatrix" );
} /*LoadPMatrix*/

void LoadMMatrix ( TransBl *trans, GLfloat mm[16] )
{
  GLfloat mmti[16];

  if ( mm )
    memcpy ( trans->mm, mm, 16*sizeof(GLfloat) );
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[0], 16*sizeof(GLfloat), trans->mm );
  M4x4TInvertf ( mmti, trans->mm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[1], 16*sizeof(GLfloat), mmti );
  ExitIfGLError ( "LoadMMatrix" );
} /*LoadMMatrix*/

