#version 420

layout(triangles,equal_spacing) in;

in vec3 TCColour[];

out NVertex {
    vec3 Colour;
    vec3 Position;
    vec3 Normal;
  } Out;

uniform TransBlock {
  mat4 mm, mmti, vm, pm, vpm;
  vec4 eyepos;
} trb;

void main ( void )
{
  float s, t, u;
  vec4  vert, vv;

  s = gl_TessCoord.x;  t = gl_TessCoord.y;  u = gl_TessCoord.z;
  vert = s*gl_in[0].gl_Position + t*gl_in[1].gl_Position + u*gl_in[2].gl_Position;
  vert.xyz = normalize ( vert.xyz );  vert.w = 1.0;
  vv = trb.mm * vert;
  gl_Position = trb.vpm * vv;
  Out.Colour = s*TCColour[0] + t*TCColour[1] + u*TCColour[2];
  Out.Position = vv.xyz/vv.w;
  Out.Normal = normalize ( mat3(trb.mmti) * vert.xyz );
} /*main*/
