#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h" /* najpierw ten */
#include <GL/freeglut.h>  /* potem ten */

#include "../utilities/utilities.h"
#include "app1.h"
#include "app1proc.h"

int WindowHandle;
int opti = 0;

void ReshapeFunc ( int width, int height )
{
  ResizeMyWorld ( width, height );
  opti = 4;
} /*ReshapeFunc*/

void DisplayFunc ( void )
{
  if ( opti > 0 ) {
    opti --;
    glutPostWindowRedisplay ( WindowHandle );
  }
  else
    RedrawMyWorld ();
  glutSwapBuffers ();
} /*DisplayFunc*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glutDestroyWindow ( WindowHandle );
} /*Cleanup*/

void KeyboardFunc ( unsigned char charcode, int x, int y )
{
  switch ( charcode ) {
case 0x1B:            /* klawisz Esc - zatrzymanie programu */
    Cleanup ();
    glutLeaveMainLoop ();
    break;
default:
    if ( ProcessCharCommand ( charcode ) )
      glutPostWindowRedisplay ( WindowHandle );
    break;
  }
} /*KeyboardFunc*/

void SpecialKeyFunc ( int key, int x, int y ) { }
void MouseFunc ( int button, int state, int x, int y ) {  }
void MotionFunc ( int x, int y ) {  }
void JoystickFunc ( unsigned int buttonmask, int x, int y, int z ) { }
void TimerFunc ( int value ) {  }
void IdleFunc ( void ) {  }

void Initialise ( int argc, char *argv[] )
{
  glutInit ( &argc, argv );
  glutInitContextVersion ( 2, 1 );
  glutInitContextFlags ( GLUT_FORWARD_COMPATIBLE );
  glutInitContextProfile ( GLUT_CORE_PROFILE );
  glutSetOption ( GLUT_ACTION_ON_WINDOW_CLOSE,
                  GLUT_ACTION_GLUTMAINLOOP_RETURNS );
  glutInitWindowSize ( 480, 360 );
  glutInitDisplayMode ( GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA );
  WindowHandle = glutCreateWindow ( "Pierwsza aplikacja" );
  if ( WindowHandle < 1 )
    ExitOnError ( "Could not create a window." );
  GetGLProcAddresses ( APP1_GL_MAJOR, APP1_GL_MINOR );
  glutReshapeFunc ( ReshapeFunc );
  glutDisplayFunc ( DisplayFunc );
  glutKeyboardFunc ( KeyboardFunc );
  glutSpecialFunc ( SpecialKeyFunc );
  glutMouseFunc ( MouseFunc );
  glutMotionFunc ( MotionFunc );
  /*glutJoystickFunc ( JoystickFunc, 16 );*/
  /*glutTimerFunc ( 0, TimerFunc, 0 );*/
  /*glutIdleFunc ( IdleFunc );*/
  InitMyWorld ( argc, argv, 480, 360 );
} /*Initialise*/

int main ( int argc, char *argv[] )
{
  Initialise ( argc, argv );
  glutMainLoop ();
  exit ( 0 );
} /*main*/
