#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "openglheader.h"

#include "utilities.h"
#include "initwglctx.h"

#define WGL_CONTEXT_PROFILE_MASK_ARB      0x9126
#define WGL_CONTEXT_CORE_PROFILE_BIT_ARB  0x00000001
#define WGL_NUMBER_PIXEL_FORMATS_ARB      0x2000
#define WGL_DRAW_TO_WINDOW_ARB            0x2001
#define WGL_ACCELERATION_ARB              0x2003
#define WGL_SUPPORT_OPENGL_ARB            0x2010
#define WGL_DOUBLE_BUFFER_ARB             0x2011
#define WGL_PIXEL_TYPE_ARB                0x2013
#define WGL_COLOR_BITS_ARB                0x2014
#define WGL_DEPTH_BITS_ARB                0x2022
#define WGL_STENCIL_BITS_ARB              0x2023
#define WGL_FULL_ACCELERATION_ARB         0x2027
#define WGL_TYPE_RGBA_ARB                 0x202B
#define WGL_SAMPLE_BUFFERS_ARB            0x2041
#define WGL_SAMPLES_ARB                   0x2042
#define WGL_CONTEXT_MAJOR_VERSION_ARB     0x2091
#define WGL_CONTEXT_MINOR_VERSION_ARB     0x2092
#define WGL_CONTEXT_FLAGS_ARB             0x2094

typedef char* (WINAPI* PFNWGLGETEXTENSIONSSTRINGEXTPROC)(void);
typedef char* (WINAPI* PFNWGLGETEXTENSIONSSTRINGARBPROC)(HDC hdc);

typedef HGLRC(WINAPI* PFNWGLCREATECONTEXTATTRIBSARBPROC)(HDC hDC, HGLRC hShareContext, const int* attribList);
typedef BOOL(WINAPI* PFNWGLCHOOSEPIXELFORMATARBPROC)(HDC hdc, const int* piAttribIList, const FLOAT* pfAttribFList, UINT nMaxFormats, int* piFormats, UINT* nNumFormats);
typedef BOOL(WINAPI* PFNWGLGETPIXELFORMATATTRIBIVARBPROC)(HDC gdc, int iPixelFormat, int iLayerPlane, UINT nAtributes, const int *piAttributes, int *piValues);

static PFNWGLCREATECONTEXTATTRIBSARBPROC   wglCreateContextAttribsARB;
static PFNWGLCHOOSEPIXELFORMATARBPROC      wglChoosePixelFormatARB;
static PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARB;

static char *wglextensions = NULL;

void InitWGLExtensions ( GLint major, GLint minor )
{
  PFNWGLGETEXTENSIONSSTRINGARBPROC wglGetExtensionsStringARB;
  PFNWGLGETEXTENSIONSSTRINGEXTPROC wglGetExtensionsStringEXT;
  WNDCLASSA             wclass;
  HWND                  dummy_window;
  HDC                   dummy_dc;
  HGLRC                 dummy_context;
  PIXELFORMATDESCRIPTOR pfd;
  int                   pixel_format;

  memset ( &wclass, 0, sizeof(WNDCLASSA) );
  wclass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wclass.lpfnWndProc = DefWindowProcA;
  wclass.hInstance = GetModuleHandle ( 0 );
  wclass.lpszClassName = "Dummy_WGL";

  if ( !RegisterClassA ( &wclass ) )
    ExitOnError("Failed to register dummy OpenGL window.");
  dummy_window = CreateWindowExA (0, wclass.lpszClassName, "Dummy OpenGL Window",
        0, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        0, 0, wclass.hInstance, 0 );
  if ( !dummy_window )
    ExitOnError ( "Failed to create dummy OpenGL window." );
  dummy_dc = GetDC ( dummy_window );
  memset ( &pfd, 0, sizeof(PIXELFORMATDESCRIPTOR) );
  pfd.nSize = sizeof(pfd);
  pfd.nVersion = 1;
  pfd.iPixelType = PFD_TYPE_RGBA;
  pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  pfd.cColorBits = 32;
  pfd.cAlphaBits = 8;
  pfd.iLayerType = PFD_MAIN_PLANE;
  pfd.cDepthBits = 24;
  pixel_format = ChoosePixelFormat ( dummy_dc, &pfd );
  if ( !pixel_format )
    ExitOnError ( "Failed to find a suitable pixel format." );
  if ( !SetPixelFormat ( dummy_dc, pixel_format, &pfd ) )
    ExitOnError ( "Failed to set the pixel format." );
  dummy_context = wglCreateContext ( dummy_dc );
  if ( !dummy_context )
    ExitOnError ( "Failed to create a dummy OpenGL rendering context." );
  if ( !wglMakeCurrent ( dummy_dc, dummy_context ) )
    ExitOnError ( "Failed to activate dummy OpenGL rendering context." );
  wglGetExtensionsStringARB =
    (PFNWGLGETEXTENSIONSSTRINGARBPROC)wglGetProcAddress ( "wglGetExtensionsStringARB" );
  if ( wglGetExtensionsStringARB )
    wglextensions = wglGetExtensionsStringARB ( dummy_dc );
  else {
    wglGetExtensionsStringEXT =
        (PFNWGLGETEXTENSIONSSTRINGEXTPROC)wglGetProcAddress("wglGetExtensionsStringEXT");
    if ( wglGetExtensionsStringEXT )
      wglextensions = wglGetExtensionsStringEXT ();
  }
  wglCreateContextAttribsARB =
    (PFNWGLCREATECONTEXTATTRIBSARBPROC)wglGetProcAddress ( "wglCreateContextAttribsARB" );
  wglChoosePixelFormatARB =
    (PFNWGLCHOOSEPIXELFORMATARBPROC)wglGetProcAddress ( "wglChoosePixelFormatARB" );
  wglGetPixelFormatAttribivARB =
    (PFNWGLGETPIXELFORMATATTRIBIVARBPROC)wglGetProcAddress ( "wglGetPixelFormatAttribivARB" );
  GetGLProcAddresses ( major, minor );
  wglMakeCurrent ( dummy_dc, 0 );
  wglDeleteContext ( dummy_context );
  ReleaseDC ( dummy_window, dummy_dc );
  DestroyWindow ( dummy_window );
} /*InitWGLExtensions*/

char IsWGLExtensionSupported ( const char *ext )
{
  if ( wglextensions )
    return strstr ( wglextensions, ext ) != NULL;
  else
    return false;
} /*IsWGLExtensionSupported*/

HGLRC InitWGLContext ( HDC real_dc, int major, int minor, int flags,
                       int *pixattr )
{
  int pixel_format_attribs[] = {
      WGL_DRAW_TO_WINDOW_ARB, GL_TRUE,
      WGL_SUPPORT_OPENGL_ARB, GL_TRUE,
      WGL_DOUBLE_BUFFER_ARB,  GL_TRUE,
      WGL_ACCELERATION_ARB,   WGL_FULL_ACCELERATION_ARB,
      WGL_PIXEL_TYPE_ARB,     WGL_TYPE_RGBA_ARB,
      WGL_COLOR_BITS_ARB,     32,
      WGL_DEPTH_BITS_ARB,     24,
      WGL_STENCIL_BITS_ARB,   8,
      WGL_SAMPLE_BUFFERS_ARB, 1,
      WGL_SAMPLES_ARB,        8,
      0 };
  int ctxattr[] = {
      WGL_CONTEXT_MAJOR_VERSION_ARB, 0,
      WGL_CONTEXT_MINOR_VERSION_ARB, 0,
      WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_CORE_PROFILE_BIT_ARB,
      WGL_CONTEXT_FLAGS_ARB,         0,
      0 };
  int                   pixel_format;
  UINT                  num_formats;
  PIXELFORMATDESCRIPTOR pfd;
  HGLRC                 gl_context;

  if ( !pixattr )
    pixattr = pixel_format_attribs;
  wglChoosePixelFormatARB ( real_dc, pixattr, NULL, 1, &pixel_format, &num_formats );
  if ( !num_formats )
    ExitOnError ( "Failed to set the OpenGL pixel format 1." );
  DescribePixelFormat ( real_dc, pixel_format, sizeof(pfd), &pfd  );
  if ( !SetPixelFormat ( real_dc, pixel_format, &pfd ) )
    ExitOnError ( "Failed to set the OpenGL pixel format 2." );
  ctxattr[1] = major;  ctxattr[3] = minor;  ctxattr[7] = flags;
  gl_context = wglCreateContextAttribsARB ( real_dc, 0, ctxattr );
  if ( !gl_context )
    ExitOnError ( "Failed to create OpenGL context." );
  if ( !wglMakeCurrent ( real_dc, gl_context ) )
    ExitOnError ( "Failed to activate OpenGL context." );
  return gl_context;
} /*InitWGLContext*/
