
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "openglheader.h"

#include "utilities.h"
#include "GPUsparsemat.h"

static GLuint program_id;
static GLuint uloc[2];

void LoadGPUSMultMVfShader ( void )
{
  static const char *filename[] = { "multsmvf.comp.glsl" };
  static const GLchar *uname[] = { "m", "dim" };
  GLuint shader_id;
  int i;

  shader_id = CompileShaderFiles ( GL_COMPUTE_SHADER, 1, &filename[0] );
  program_id = LinkShaderProgram ( 1, &shader_id, "GPUSMultMVf" );
  for ( i = 0; i < 2; i++ )
    uloc[i] = glGetUniformLocation ( program_id, uname[i] );
  glDeleteShader ( shader_id );
  ExitIfGLError ( "LoadGPUMultMVShader" );
} /*LoadGPUMultMVfShader*/

void DeleteGPUSMultMVfProgram ( void )
{
  glDeleteProgram ( program_id );
} /*DeleteGPUSMultMVfProgram*/

void GPUSMultSparseMatrixVectorf ( GLuint ybuf,
                         GPUSparseMatrix *a, GLuint dim, GLuint xbuf )
{
  glUseProgram ( program_id );
  glUniform1ui ( uloc[0], a->m );
  glUniform1ui ( uloc[1], dim );
  glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, 0, a->buf[0] );
  glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, 1, a->buf[1] );
  glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, 2, xbuf );
  glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, 3, ybuf );
  COMPUTE ( a->m, dim, 1 )
  ExitIfGLError ( "GPUSMultSparseMatrixVectorf" );
} /*GPUSMultSparseMatrixVectorf*/
#undef COMPUTE

