
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "myheader.h"

const GLchar *vertsh[] =
 {"#version 420 core\n"
  "out vec4 colour;"
  "const vec4 p[3] = {{0.9,-0.9,0,1},{0,0.9,0,1},{-0.9,-0.9,0,1}};"
  "const vec4 c[3] = {{1,0,0,1},{0,1,0,1},{0,0,1,1}};"
  "void main ( void )"
  "{"
    "gl_Position = p[gl_VertexID];"
    "colour = c[gl_VertexID];"
  "}"};
const GLchar* fragsh[] =
 {"#version 420 core\n"
  "in vec4 colour;"
  "out vec4 Colour;"
  "void main ( void )"
  "{"
    "Colour = colour;"
  "}"};

GLuint prog_id, vao;

void CompileMyShaders ( void )
{
  GLuint sh_id[2];

  sh_id[0] = CompileShaderStrings ( GL_VERTEX_SHADER, 1, vertsh, NULL);
  sh_id[1] = CompileShaderStrings ( GL_FRAGMENT_SHADER, 1, fragsh, NULL);
  prog_id = LinkShaderProgram ( 2, sh_id, "" );
  glDeleteShader ( sh_id[0] );
  glDeleteShader ( sh_id[1] );
  ExitIfGLError ( "CompileMyShaders" );
} /*CompileMyShaders*/

void InitMyWorld ( int argc, char *argv[], int width, int height )
{
  PrintGLVersion ();
  CompileMyShaders ();
  glGenVertexArrays ( 1, &vao );
  ExitIfGLError ( "InitMyWorld" );
} /*InitMyObjest*/

void ResizeMyWorld ( int width, int height )
{
  glViewport ( 0, 0, width, height );
} /*ResizeMyWorld*/

void RedrawMyWorld ( void )
{
  glClearColor ( 0.0, 0.5, 1.0, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT );
  glUseProgram ( prog_id );
  glBindVertexArray ( vao );
  glDrawArrays ( GL_TRIANGLES, 0, 3 );
  glBindVertexArray ( 0 );
  glUseProgram ( 0 );
  glFlush();
  ExitIfGLError("RedrawMyWorld");
} /*Redraw*/

void DeleteMyWorld ( void )
{
  glDeleteProgram ( prog_id );
  glDeleteVertexArrays ( 1, &vao );
  ExitIfGLError ( "DeleteMyWorld" );
} /*DeleteMyWorld*/
