#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "trans.h"

#define NTRUOFFS 8

static GLuint trbbp = GL_INVALID_INDEX;
static GLint  trbsize, trbofs[NTRUOFFS];
static const GLchar *UTBNames[NTRUOFFS+1] =
  { "TransBlock", "TransBlock.mm", "TransBlock.mmti", "TransBlock.vm",
    "TransBlock.pm", "TransBlock.vpm", "TransBlock.vpmi",
    "TransBlock.eyepos", "TransBlock.viewport" };

GLuint GetAccessToTransBlockUniform ( GLuint program_id )
{
  if ( trbbp == GL_INVALID_INDEX )
    GetAccessToUniformBlock ( program_id, NTRUOFFS, &UTBNames[0],
                              &trbsize, trbofs, &trbbp );
  else
    AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
  return trbbp;
} /*GetAccessToTransBlockUniform*/

GLuint NewUniformTransBlock ( void )
{
  return NewUniformBuffer ( trbsize, trbbp );
} /*NewUniformTransBlock*/

void AttachUniformTransBlockToBP ( GLuint program_id )
{
  AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
} /*AttachUniformTransBlockToBP*/

void LoadViewport ( TransBl *trans, GLint x0, GLint y0, GLint w, GLint h )
{
  trans->viewport[0] = (GLfloat)x0;  trans->viewport[1] = (GLfloat)y0;
  trans->viewport[2] = (GLfloat)w;   trans->viewport[3] = (GLfloat)h;
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[7], 4*sizeof(GLfloat), trans->viewport );
  glViewport ( x0, y0, w, h );
  ExitIfGLError ( "LoadViewport" );
} /*LoadViewport*/

void LoadVPMatrix ( TransBl *trans )
{
  GLfloat vpm[16], vpmi[16];

  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[2], 16*sizeof(GLfloat), trans->vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[3], 16*sizeof(GLfloat), trans->pm );
  M4x4Multf ( vpm, trans->pm, trans->vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[4], 16*sizeof(GLfloat), vpm );
  M4x4Invertf ( vpmi, vpm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[5], 16*sizeof(GLfloat), vpmi );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[6], 4*sizeof(GLfloat), trans->eyepos );
  ExitIfGLError ( "LoadVPMatrix" );
} /*LoadVPMatrix*/

void LoadAltVPMatrix ( TransBl *trans, GLfloat vm[16], GLfloat pm[16],
                       GLfloat eyepos[4] )
{
  GLfloat vpm[16], vpmi[16];

  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[2], 16*sizeof(GLfloat), vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[3], 16*sizeof(GLfloat), pm );
  M4x4Multf ( vpm, pm, vm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[4], 16*sizeof(GLfloat), vpm );
  M4x4Invertf ( vpmi, vpm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[5], 16*sizeof(GLfloat), vpmi );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[6], 4*sizeof(GLfloat), eyepos );
  ExitIfGLError ( "LoadAltVPMatrix" );
} /*LoadAltVPMatrix*/

void LoadMMatrix ( TransBl *trans, GLfloat mm[16] )
{
  GLfloat mmti[16];

  if ( mm )
    memcpy ( trans->mm, mm, 16*sizeof(GLfloat) );
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[0], 16*sizeof(GLfloat), trans->mm );
  M4x4TInvertf ( mmti, trans->mm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[1], 16*sizeof(GLfloat), mmti );
  ExitIfGLError ( "LoadMMatrix" );
} /*LoadMMatrix*/

