#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "myscene.h"
#include "texture.h"
#include "room.h"

#define TEXTURE_WH 1024

#define X0  (-3.0)
#define X1  3.0
#define Y0  (-2.0)
#define Y1  2.0
#define Z0  FLOOR_Z
#define Z1  (Z0+3.0)
#define D0X (-2.35)
#define D1X (-1.5)
#define D0Z Z0
#define D1Z (Z0+2.0)
#define W0X (-2.25)
#define W1X (-0.75)
#define W2X 0.75
#define W3X 2.25
#define W0Z (Z0+1.0)
#define W1Z (Z0+2.7)
#define WTH 0.1
#define X2 (-0.5)
#define Y2 (Y0-WTH)
#define Y3 (Y2-1.5)
#define STH 0.03  /* grubosc parapetu */
#define SE  0.15  /* pol serokosci parapetu */
#define WFT 0.1   /* szerokosc ramy okna */
#define S0Y (Y1-SE)
#define S1Y (Y1+SE)
#define S0Z (W0Z+STH)
#define S1Z (S0Z+WFT)
#define S2Z (W1Z-WFT)
#define S1X (W0X+WFT)
#define S2X (W1X-WFT)
#define S3X (0.5*(W0X+W1X-WFT))
#define S4X (0.5*(W0X+W1X+WFT))
#define S5X (W2X+WFT)
#define S6X (W3X-WFT)
#define S7X (0.5*(W2X+W3X-WFT))
#define S8X (0.5*(W2X+W3X+WFT))
#define XE0 (X0-0.2)
#define XE1 (X1+0.2)
#define YE0 (Y3-0.2)
#define YE1 (S1Y+0.1)
#define ZE0 (Z0-0.3)
#define ZE1 (Z1+0.3)

#define NVERT    100
#define NTRIANG  136
#define NBVERT    84
#define NBTRIANG 100

static GLfloat vertpos[NVERT][3] = {
  {X0,Y0,Z0},{X1,Y0,Z0},{X1,Y1,Z0},{X0,Y1,Z0},  /* narozniki pomieszczenia */
  /* 4 */
  {X0,Y0,Z1},{X1,Y0,Z1},{X1,Y1,Z1},{X0,Y1,Z1},
  /* 8 */
  {D0X,Y0,Z0},{D1X,Y0,Z0},{D1X,Y0,D1Z},{D0X,Y0,D1Z},  /* otwor framugi */
  {D1X,Y0,Z1},{D0X,Y0,Z1},                      /* wierzcholki nad framuga */
  /* 14 */
  {W0X,Y1,W0Z},{W1X,Y1,W0Z},{W1X,Y1,W1Z},{W0X,Y1,W1Z},  /* otwor lewego okna */
  {W2X,Y1,W0Z},{W3X,Y1,W0Z},{W3X,Y1,W1Z},{W2X,Y1,W1Z},  /* otwor prawego okna */
  {X0,Y1,W0Z},{X1,Y1,W0Z},{X1,Y1,W1Z},{X0,Y1,W1Z},
  /* 26 */
  {D0X,Y2,Z0},{D1X,Y2,Z0},{D1X,Y2,D1Z},{D0X,Y2,D1Z}, /* wneka framugi */
  /* 30 */
  {X0,Y3,Z0},{X2,Y3,Z0},{X2,Y2,Z0},{X0,Y2,Z0},
  {X0,Y3,Z1},{X2,Y3,Z1},{X2,Y2,Z1},{X0,Y2,Z1}, /* narozniki przedpokoju */
  {D0X,Y2,Z1},{D1X,Y2,Z1},
  /* 40 */
  {W0X,S0Y,W0Z},{W1X,S0Y,W0Z},{W0X,S0Y,S0Z},{W1X,S0Y,S0Z},
  {W0X,Y1,S0Z},{W1X,Y1,S0Z},{W0X,S1Y,S0Z},{W1X,S1Y,S0Z},
  /* 48*/
  {W0X,Y1,S0Z},{S1X,S1Y,S1Z},{W1X,Y1,S0Z},{S2X,S1Y,S1Z},
  {W0X,Y1,W1Z},{W1X,Y1,W1Z},{W0X,S1Y,W1Z},{W1X,S1Y,W1Z},
  {S1X,S1Y,S2Z},{S2X,S1Y,S2Z},
  {S3X,S1Y,S1Z},{S4X,S1Y,S1Z},{S3X,S1Y,S2Z},{S4X,S1Y,S2Z},  /* lewy parapet i okno */
  /* 62 */
  {W2X,S0Y,W0Z},{W3X,S0Y,W0Z},{W2X,S0Y,S0Z},{W3X,S0Y,S0Z},
  {W2X,Y1,S0Z},{W3X,Y1,S0Z},{W2X,S1Y,S0Z},{W3X,S1Y,S0Z},
  /* 70*/
  {W2X,Y1,S0Z},{S5X,S1Y,S1Z},{W3X,Y1,S0Z},{S6X,S1Y,S1Z},
  {W2X,Y1,W1Z},{W3X,Y1,W1Z},{W2X,S1Y,W1Z},{W3X,S1Y,W1Z},
  {S5X,S1Y,S2Z},{S6X,S1Y,S2Z},
  {S7X,S1Y,S1Z},{S8X,S1Y,S1Z},{S7X,S1Y,S2Z},{S8X,S1Y,S2Z},  /* prawy parapet i okno */
  /* 84 */
  {XE1,YE1,ZE0},{XE0,YE1,ZE0},{XE1,YE0,ZE0},{XE0,YE0,ZE0},
  {XE1,YE0,ZE1},{XE0,YE0,ZE1},{XE1,YE1,ZE1},{XE0,YE1,ZE1},
  /* 92 */
  {S1X,YE1,S1Z},{S1X,YE1,S2Z},{S2X,YE1,S2Z},{S2X,YE1,S1Z},
  {S5X,YE1,S1Z},{S5X,YE1,S2Z},{S6X,YE1,S2Z},{S6X,YE1,S1Z}  /* sciany zewnetrzne */
  /* 100 */
  };
static GLfloat verttxc[NVERT][2] = {
  {0.0,0.0},{12.0,0.0},{12.0,8.0},{0.0,8.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{1.3,0.0},{3.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{1.3,0.0},{3.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{1.3,-0.2},{3.0,-0.2},{0.0,0.0},{0.0,0.0},
  {0.0,-3.2},{5.0,-3.2},{5.0,-0.2},{0.0,-0.2},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},
  {0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0},{0.0,0.0}};
static GLubyte roomindex[3*NTRIANG] = {
   0,1,2,  0,2,3,        /* podloga */
   30,31,32,  30,32,33,  9,8,26,  9,26,27,  /* podloga przedpokoju */
   /* 6 */
   3,2,23,  3,23,22,  25,24,6,  25,6,7,  22,14,17,  22,17,25,
   15,18,21,  15,21,16,  19,23,24,  19,24,20,  /* sciana z oknem */
   /* 16 */
   46,49,56,  46,56,54,  56,57,55,  56,55,54,  51,47,55,  51,55,57,
   46,47,51,  46,51,49,  58,59,61,  58,61,60,  /* lewa rama okna */
   /* 26 */
   68,71,78,  68,78,76,  78,79,77,  78,77,76,  73,69,77,  73,77,79,
   68,69,73,  68,73,71,  80,81,83,  80,83,82,  /* prawa rama okna */
   /* 36 */
   0,3,7,  0,7,4,        /* lewa sciana */
   2,1,5,  2,5,6,        /* prawa sciana*/
   7,6,5,  7,5,4,        /* sufit */
   /* 12 */
   1,9,12,  1,12,5,  10,11,13,  10,13,12,  8,0,4,  8,4,13, /* sciana z drzwiami */
   /* 48 */
   11,29,26,  11,26,8,
   28,29,11,  28,11,10,  9,27,28,  9,28,10,  /* wneka framugi drzwi */
   /* 54 */
   30,33,37,  30,37,34,  /* lewa sciana przedpokoju */
   32,31,35,  32,35,36,  /* prawa sciana przedpokoju */
   31,30,34,  31,34,35,
   37,36,35,  37,35,34,  /* sufit przedpokoju */
   33,26,38,  33,38,37,  29,28,39,  29,39,38,
   27,32,36,  27,36,39,  /* sciana przedpokoju z drzwiami */
   /* 68 */
   14,15,41,  14,41,40,  40,41,43,  40,43,42,  42,43,47,  42,47,46,
   14,40,42,  14,42,44,  41,15,45,  41,45,43,  /* lewy parapet*/
   /* 78 */
   48,46,54,  48,54,52,  54,55,53,  54,53,52,  47,50,53,  47,53,55,  /* lewa wneka okna */
   /* 84 */
   18,19,63,  18,63,62,  62,63,65,  62,65,64,  64,65,69,  64,69,68,
   18,62,64,  18,64,66,  63,19,67,  63,67,65,  /* prawy parapet*/
   /* 94 */
   70,68,76,  70,76,74,  76,77,75,  76,75,74,  69,72,75,  69,75,77,  /* prawa wneka okna */
   /* 100 */
   85,87,89,  85,89,91,  92,85,91,  92,91,93,  84,85,92,  84,92,99,
   98,93,91,  98,91,90,  84,99,98,  84,98,90,  86,84,90,  86,90,88,
   86,87,85,  86,85,84,  88,89,87,  88,87,86,  90,91,89,  90,89,88,
   96,95,94,  96,94,97,  /* sciany zewnetrzne */
   49,92,93,  49,93,56,  95,92,49,  95,49,51,  95,51,57,  95,57,94,
   57,56,93,  57,93,94,  71,96,97,  71,97,78,  99,96,71,  99,71,73,
   99,73,79,  99,79,98,  79,78,97,  79,97,98  /* zewnetrze okien */
   };

static const GLfloat diffr0[4] = { 0.86, 0.86, 0.93, 1.0 };  /* material scian */
static const GLfloat specr0[4] = { 0.0, 0.0, 0.0, 1.0 };

static const GLfloat diffr1[4] = { 0.6, 0.4, 0.25, 1.0 };  /* material podlogi */
static const GLfloat specr1[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterRoomWalls ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  GLuint        tex;

  strcpy ( obj->name, "room" );
  obj->mat0 = SetupMaterial ( matbl, -1, diffr0, specr0,
                              1.0, 1.0, 1.0, GL_INVALID_INDEX );
  tex = CreateMyTexture ( TEXTURE_WH );
  LoadMyTextureImage ( tex, TEXTURE_WH, TEXTURE_WH, 0, 0, "../tiff/floor2.tif" );
  SetupMyTextureMipmaps ( tex );
  SetupMaterial ( matbl, -1, diffr1, specr1, 1.0, 1.0, 1.0, tex );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 3, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*3*sizeof(GLfloat),
                 vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*2*sizeof(GLfloat),
                   verttxc, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 1 );
  glVertexAttribPointer ( 1, 2, GL_FLOAT, GL_FALSE,
                          2*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[2] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER, NTRIANG*3*sizeof(GLubyte),
                 roomindex, GL_STATIC_DRAW );
  glBindVertexArray ( 0 );
  obj->redraw = DrawRoomWalls;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NBVERT;  obj->ntr = NBTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 0, NBVERT, NBTRIANG, ROOM_ELD );
  EnterTriangles ( belem, GL_TRIANGLES, NBVERT, vertpos, verttxc,
                   6*3, GL_UNSIGNED_BYTE, roomindex, obj->mat0+1, true );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   10*3, GL_UNSIGNED_BYTE, &roomindex[6*3], obj->mat0, true );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   10*3, GL_UNSIGNED_BYTE, &roomindex[16*3], obj->mat0, true );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   10*3, GL_UNSIGNED_BYTE, &roomindex[26*3], obj->mat0, true );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   (NBTRIANG-36)*3, GL_UNSIGNED_BYTE, &roomindex[36*3], obj->mat0,
                   false );
  EndEnteringObjTriangles ( belem );
  M4x4Identf ( obj->mm );
  ExitIfGLError ( "EnterRoomWalls" );
} /*EnterRoomWalls*/

void DrawRoomWalls ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glBindVertexArray ( obj->vao );
  ChooseMaterial ( mat, obj->mat0+1 );
  glDrawElements ( GL_TRIANGLES, 6*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawElements ( GL_TRIANGLES, (NTRIANG-6)*3, GL_UNSIGNED_BYTE, (GLvoid*)(6*3) );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawRoomWalls" );
} /*DrawRoomWalls*/

/* ////////////////////////////////////////////////////////////////////////// */
#define DW  (D1X-(D0X))
#define DH  (D1Z-(D0Z))
#define DTH 0.04

#define NDVERT    8
#define NDTRIANG 10

static GLfloat dvertpos[NDVERT][3] = {
  {0.0,0.0,0.0},{0.0,DTH,0.0},{0.0,DTH,DH},{0.0,0.0,DH},
  {DW,0.0,0.0},{DW,DTH,0.0},{DW,DTH,DH},{DW,0.0,DH}};
static GLubyte dindex[3*NDTRIANG] = {
  0,4,7,  0,7,3,  3,7,6,  3,6,2,  2,6,5,
  2,5,1,  1,0,3,  1,3,2,  4,5,6,  4,6,7};

static const GLfloat diffr2[4] = { 0.5, 0.3, 0.15, 1.0 };  /* material drzwi */
static const GLfloat specr2[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterDoor ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  strcpy ( obj->name, "door" );
  obj->mat0 = SetupMaterial ( matbl, -1, diffr2, specr2,
                              1.0, 1.0, 1.0, GL_INVALID_INDEX );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 2, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NDVERT*3*sizeof(GLfloat),
                 dvertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER, NDTRIANG*3*sizeof(GLubyte),
                 dindex, GL_STATIC_DRAW );
  glDisableVertexAttribArray ( 1 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawDoor;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NDVERT;  obj->ntr = NDTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 0, NDVERT, NDTRIANG, DOOR_ELD );
  EnterTriangles ( belem, GL_TRIANGLES, NDVERT, dvertpos, NULL,
                   NDTRIANG*3, GL_UNSIGNED_BYTE, dindex, obj->mat0, false );
  EndEnteringObjTriangles ( belem );
  M4x4Translatef ( obj->mm, D0X, Y0, Z0 );
  ExitIfGLError ( "EnterDoor" );
} /*EnterDoor*/

void SetDoorAperture ( SceneObject *obj, double angle )
{
  M4x4RotateZf ( obj->mm, angle );
  M4x4TranslateMf ( obj->mm, D0X, Y0, Z0 );
} /*SetDoorAperture*/

void DrawDoor ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glBindVertexArray ( obj->vao );
  glDrawElements ( GL_TRIANGLES, NTRIANG*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawDoor" );
} /*DrawDoor*/

/* ////////////////////////////////////////////////////////////////////////// */
#define NLVERT    78
#define NLTRIANG 116

#define A 0.52573115
#define B 0.85065085
static const GLfloat lvertpos[12][3] =
  {{ -A,0.0, -B},{  A,0.0, -B},{0.0, -B, -A},{ -B, -A,0.0},
   { -B,  A,0.0},{0.0,  B, -A},{  A,0.0,  B},{ -A,0.0,  B},
   {0.0, -B,  A},{  B, -A,0.0},{  B,  A,0.0},{0.0,  B,  A}};
#undef A
#undef B
static const GLubyte lev[30][2] =
   {{0,1},{0,2},{0,3},{0,4},{0,5},
    {2,1},{3,2},{4,3},{5,4},{1,5},
    {1,9},{2,9},{2,8},{3,8},{3,7},
    {4,7},{4,11},{5,11},{5,10},{1,10},
    {9,8},{8,7},{7,11},{11,10},{10,9},
    {9,6},{8,6},{7,6},{11,6},{10,6}};
static const GLubyte lindex[240] =
   {0,12,13,  0,13,14,  0,14,15,  0,15,16,  0,16,12,
    12,17,13,  13,17,2,  13,2,18,  13,18,14,  14,18,3,
    14,3,19,  14,19,15,  15,19,4,  15,4,20,  15,20,16,
    16,20,5,  16,5,21,  16,21,12,  12,21,1,  12,1,17,
    1,22,17,  17,22,23,  17,23,2,  2,23,24,  2,24,18,
    18,24,25,  18,25,3,  3,25,26,  3,26,19,  26,27,19,
    19,27,4,  4,27,28,  4,28,20,  20,28,29,  20,29,5,
    5,29,30,  5,30,21,  21,30,31,  21,31,1,  1,31,22,
    22,9,23,  23,9,32,  23,32,24,  24,32,8,  24,8,25,
    25,8,33,  25,33,26,  26,33,7,  26,7,27,  27,7,34,
    27,34,28,  28,34,11,  28,11,29,  29,11,35,  29,35,30,
    30,35,10,  30,10,31,  31,10,36,  31,36,22,  22,36,9,
    32,9,37,  32,37,38,  32,38,8,  8,38,33,  33,38,39,
    33,39,7,  7,39,34,  34,39,40,  34,40,11,  11,40,35,
    35,40,41,  35,41,10,  10,41,36,  36,41,37,  36,37,9,
    37,6,38,  38,6,39,  39,6,40,  40,6,41,  41,6,37};

static const GLfloat lemission0[4] = {0.5,0.5,0.5,0.0},
                     lemission1[4] = {0.45,0.45,0.45,12.0};
static const GLfloat ldiffr[4] = {0.7,0.7,0.7};
static const GLfloat lspecr[4] = {0.2,0.2,0.2};

static GLfloat amb1[4] = { 0.1, 0.1, 0.092, 0.0 };
static GLfloat dir1[4] = { 1.1, 1.1, 0.98, 0.0 };
static GLfloat atn1[3] = { 0.5, 0.1, 0.5 };

void EnterMainLamp ( BalanceElements *belem, SceneObject *obj, MatBl *mat )
{
#define R1           0.3
#define R2           0.01
#define ZL           2.8571429
#define LAMPTXT_WH 256
#define LAMP_SCF     0.175
  GLfloat       lvert[NLVERT][3], lnormal[NLVERT][3];
  GLubyte       lind[280];
  float         d, c, s;
  GLuint        tex;
  int           i, j, k;

  strcpy ( obj->name, "main lamp" );
  tex = CreateMyTexture ( LAMPTXT_WH );
  LoadMyTextureImage ( tex, LAMPTXT_WH, LAMPTXT_WH, 0, 0, "../tiff/lamptxt.tif" );
  SetupMyTextureMipmaps ( tex );
  obj->mat0 = SetupMaterial ( mat, -1, ldiffr, lspecr,
                              1.0, 1.0, 1.0, tex );
  SetupMaterial ( mat, -1, ldiffr, lspecr,
                  1.0, 1.0, 1.0, GL_INVALID_INDEX );
  memcpy ( lvert, lvertpos, 12*3*sizeof(GLfloat) );
  memcpy ( lind, lindex, 80*3*sizeof(GLubyte) );
  for ( i = 0, j = 12;  i < 30;  i++, j++ ) {
    for ( k = 0; k < 3; k++ )
      lvert[j][k] = lvert[lev[i][0]][k] + lvert[lev[i][1]][k];
    V3Normalisef ( lvert[j] );
  }
  memcpy ( lnormal, lvert, 42*3*sizeof(GLfloat) );
  for ( i = 0, j = 42;  i < 12;  i++ ) {
    d = (float)(i+i)*PI/12.0;
    c = cos ( d );  s = sin ( d );
    lvert[j][0] = R1*c;  lvert[j][1] = R1*s;  lvert[j][2] = ZL;
    lnormal[j][0] = c;  lnormal[j][1] = s;  lnormal[j][2] = -1.0;
    V3Normalisef ( lnormal[j] );
    j++;
    d = (float)(i+i+1)*PI/12.0;
    c = cos ( d );  s = sin ( d );
    lvert[j][0] = R2*c;  lvert[j][1] = R2*s;  lvert[j][2] = ZL-R1;
    lnormal[j][0] = c;  lnormal[j][1] = s;  lnormal[j][2] = -1.0;
    V3Normalisef ( lnormal[j] );
    j++;
  }
  for ( i = 0;  i < 6;  i++, j += 2 ) {
    d = (float)(i+i)*PI/6.0;
    c = cos ( d );  s = sin ( d );
    lvert[j][0] = lvert[j+1][0] = R2*cos ( d );
    lvert[j][1] = lvert[j+1][1] = R2*sin ( d );
    lvert[j][2] = ZL-R1+0.01;  lvert[j+1][2] = 0.95;
    lnormal[j][0] = c;  lnormal[j][1] = s;  lnormal[j][2] = 0.0;
    V3Normalisef ( lnormal[j] );
    memcpy ( lnormal[j+1], lnormal[j], 3*sizeof(GLfloat) );
  }
  for ( i = 0, k = 240;  i < 24;  i++ )
    lind[k++] = 42+i;
  lind[k++] = 42;  lind[k++] = 43;
  for ( i = 0;  i < 12; i++ )
    lind[k++] = 66+i;
  lind[k++] = 66;  lind[k++] = 67;

  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 3, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NLVERT*3*sizeof(GLfloat), lvert, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER,
                 280*sizeof(GLubyte), lind, GL_STATIC_DRAW );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[2] );
  glBufferData ( GL_ARRAY_BUFFER, NLVERT*3*sizeof(GLfloat), lnormal, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 2 );
  glVertexAttribPointer ( 2, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawMainLamp;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NLVERT;  obj->ntr = NLTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 1, NLVERT, NLTRIANG, LAMP_ELD/LAMP_SCF );
  EnterTriangles ( belem, GL_TRIANGLES, NLVERT, lvert, NULL,
                   240, GL_UNSIGNED_BYTE, lind, obj->mat0, false );
  EnterTriangles ( belem, GL_TRIANGLE_STRIP, 0, lvert, NULL,
                   26, GL_UNSIGNED_BYTE, &lind[240], obj->mat0+1, false );
  EnterTriangles ( belem, GL_TRIANGLE_STRIP, 0, lvert, NULL,
                   14, GL_UNSIGNED_BYTE,
                   &lind[266], obj->mat0+1, false );
  EndEnteringObjTriangles ( belem );
  M4x4Scalef ( obj->mm, LAMP_SCF, LAMP_SCF, LAMP_SCF );
  M4x4TranslateMf ( obj->mm, 0.0, 0.0, Z1-0.5 );
  ExitIfGLError ( "EnterMainLamp" );
#undef R1
#undef R2
} /*EnterMainLamp*/

void DrawMainLamp ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glBindVertexArray ( obj->vao );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawElements ( GL_TRIANGLES, 80*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  ChooseMaterial ( mat, obj->mat0+1 );
  glDrawElements ( GL_TRIANGLE_STRIP, 26, GL_UNSIGNED_BYTE, (GLvoid*)240 );
  glDrawElements ( GL_TRIANGLE_STRIP, 14, GL_UNSIGNED_BYTE, (GLvoid*)266 );
  glBindVertexArray ( 0 );
} /*DrawMainLamp*/

void GetMainLampPosition ( GLfloat *pos )
{
  pos[0] = pos[1] = 0.0;  pos[2] = Z1-0.5;  pos[3] = 1.0;
} /*GetMainLampPosition*/

void SetMainLampOnOff ( SceneObject *obj, TransBl *trans, MatBl *mat,
                        LightBl *light, int l, char on )
{
  GLfloat pos[4], zero[4] = { 0.0, 0.0, 0.0, 0.0 };

  if ( on ) {
    GetMainLampPosition ( pos );
    SetLightAmbient ( light, l, amb1 );
    SetLightDiffuse ( light, l, dir1 );
    SetLightAttenuation ( light, l, atn1 );
    SetLightPosition ( light, l, pos );
    SetupShadowTxtTransformations ( light, l, pos, RS );
    SetMaterialEmission ( mat, obj->mat0, lemission0, lemission1 );
  }
  else
    SetMaterialEmission ( mat, obj->mat0, zero, zero );
} /*SetMainLampOnOff*/

/* ////////////////////////////////////////////////////////////////////////// */
#define CW   1.75
#define CH   1.25
#define CTH  0.007

#define CTEXTURE_WH (2*729)

static GLfloat cvertpos[4][3] =
  {{-CW,-CH,FLOOR_Z+CTH},{CW,-CH,FLOOR_Z+CTH},
   {CW,CH,FLOOR_Z+CTH},{-CW,CH,FLOOR_Z+CTH}};
static GLfloat cverttxc[4][2] =
  {{0.0,0.0},{1.0,0.0},{1.0,1.0},{0.0,1.0}};

void EnterCarpet ( BalanceElements *belem, SceneObject *obj, MatBl *mat )
{
  GLuint        tex;

  strcpy ( obj->name, "carpet" );
  tex = CreateMyTexture ( CTEXTURE_WH );
  LoadMyTextureImage ( tex, CTEXTURE_WH, CTEXTURE_WH, 0, 0, "../tiff/carpet.tif" );
  SetupMyTextureMipmaps ( tex );
  obj->mat0 = SetupMaterial ( mat, -1, diffr0, specr0, 1.0, 1.0, 1.0, tex );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 2, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, 4*3*sizeof(GLfloat),
                 cvertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ARRAY_BUFFER, 4*2*sizeof(GLfloat),
                 cverttxc, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 1 );
  glVertexAttribPointer ( 1, 2, GL_FLOAT, GL_FALSE,
                          2*sizeof(GLfloat), (GLvoid*)0 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawCarpet;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = 4;  obj->ntr = 2;
  BeginEnteringObjTriangles ( belem, obj, 0, 4, 2, CARPET_ELD );
  EnterTriangles ( belem, GL_TRIANGLE_FAN, 4, cvertpos, cverttxc,
                   4, GL_UNSIGNED_BYTE, NULL, obj->mat0, false );
  EndEnteringObjTriangles ( belem );
  M4x4Identf ( obj->mm );
  ExitIfGLError ( "EnterCarpet" );
} /*EnterCarpet*/

void DrawCarpet ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glBindVertexArray ( obj->vao );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawArrays ( GL_TRIANGLE_FAN, 0, 4 );
  glBindVertexArray ( 0 );
} /*DrawCarpet*/

