#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "balance.h"
#include "trans.h"
#include "lights.h"
#include "sobject.h"
#include "onetriang.h"

#define NVERT 3
#define NTRIANG 1

static GLfloat vertpos[NVERT][3] =
  {{-0.4,0.4,-0.1},{-0.5,1.2,-0.2},{-1.0,0.9,0.25}};
static const GLfloat diffr0[4] = {0.9,0.9,0.9,1.0};

void EnterOneTriang ( SceneObject *obj, MatBl *matbl )
{
  obj->mat0 = SetupMaterial ( matbl, -1, diffr0, diffr0,
                              5.0, 1.0, 1.0, GL_INVALID_INDEX );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 1, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*3*sizeof(GLfloat),
                 vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glDisableVertexAttribArray ( 1 );
  glDisableVertexAttribArray ( 2 );
  glBindVertexArray ( 0 );
  obj->nv = NVERT;  obj->ntr = NTRIANG;
  M4x4Identf ( obj->mm );
  ExitIfGLError ( "EnterOneTriangle" );
} /*EnterOneTriang*/

void DrawOneTriang ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  M4x4Copyf ( trans->mm, obj->mm );
  LoadMMatrix ( trans );
  glUseProgram ( prog_id );
  glBindVertexArray ( obj->vao );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawArrays ( GL_TRIANGLES, 0, NTRIANG*3 );
  glBindVertexArray ( 0 );
} /*DrawOneTriang*/

