#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "scanner.h"
#include "readsmf.h"
#include "myscene.h"
#include "galleon.h"

#define fn "../smf/galleon.smf"
#define SCF 0.75
#define N1  2620

static const GLfloat diffr0[4] = { 0.48, 0.22, 0.14, 1.0 };
static const GLfloat specr0[4] = { 0.2, 0.2, 0.2, 1.0 };
static const GLfloat diffr1[4] = { 0.95, 0.95, 0.95, 1.0 };
static const GLfloat specr1[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterGalleon ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  GLfloat       *vc;
  GLint         *trv;
  GLushort      *trvs;
  int           i;

  if ( ReadSMFFile ( fn, &obj->nvert, &vc, &obj->ntr, &trv ) ) {
    strcpy ( obj->name, "galleon" );
    printf ( "%s: nvert = %d, ntr = %d\n", fn, obj->nvert, obj->ntr );
    obj->mat0 = SetupMaterial ( matbl, -1, diffr0, specr0,
                                10.0, 1.0, 1.0, GL_INVALID_INDEX );
    SetupMaterial ( matbl, -1, diffr1, specr1,
                    10.0, 1.0, 1.0, GL_INVALID_INDEX );
    glGenVertexArrays ( 1, &obj->vao );
    glBindVertexArray ( obj->vao );
    glGenBuffers ( 2, obj->vbo );
    glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
    glBufferData ( GL_ARRAY_BUFFER, obj->nvert*3*sizeof(GLfloat),
                   vc, GL_STATIC_DRAW );
    glEnableVertexAttribArray ( 0 );
    glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                            3*sizeof(GLfloat), (GLvoid*)0 );
    glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
    if ( obj->nvert < RESTART_IND_USHORT ) {
      trvs = (GLushort*)trv;
      for ( i = 0; i < 3*obj->ntr; i++ )
        trvs[i] = (GLushort)trv[i];
      glBufferData ( GL_ELEMENT_ARRAY_BUFFER, 3*obj->ntr*sizeof(GLushort),
                     trvs, GL_STATIC_DRAW );
      obj->index_type = GL_UNSIGNED_SHORT;
    }
    else {
      glBufferData ( GL_ELEMENT_ARRAY_BUFFER, 3*obj->ntr*sizeof(GLuint),
                     trv, GL_STATIC_DRAW );
      obj->index_type = GL_UNSIGNED_INT;
    }
    glDisableVertexAttribArray ( 1 );
    glDisableVertexAttribArray ( 2 );
    glBindVertexArray ( 0 );
    obj->redraw = DrawGalleon;
    obj->destroy = DestroySceneObject;
    obj->active = true;
    BeginEnteringObjTriangles ( belem, obj, 0, obj->nvert, obj->ntr,
                                GALLEON_ELD/SCF );
    EnterTriangles ( belem, GL_TRIANGLES, obj->nvert, (GLfloat(*)[3])vc, NULL,
                     3*N1, obj->index_type, trv, obj->mat0, false );
    EnterTriangles ( belem, GL_TRIANGLES, 0, NULL, NULL,
                     3*(obj->ntr-N1), obj->index_type,
                     obj->nvert < RESTART_IND_USHORT ?
                     (GLvoid*)&trvs[3*N1] : (GLvoid*)&trv[3*N1],
                     obj->mat0+1, false );
    EndEnteringObjTriangles ( belem );
    free ( trv );
    free ( vc );
    ExitIfGLError ( "EnterGalleon" );
  }
  else
    ExitOnError ( "EnterGalleon" );
} /*EnterGalleon*/

void SetGalleonPosition ( SceneObject *obj, float x, float y, float z )
{
  M4x4Scalef ( obj->mm, SCF, SCF, SCF );
  M4x4RotateXMf ( obj->mm, 0.5*PI );
  M4x4RotateZMf ( obj->mm, 0.5*PI );
  M4x4TranslateMf ( obj->mm, x, y, z );
} /*SetGalleonPosition*/

void DrawGalleon ( GLuint prog_id, SceneObject *obj,
                   TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glBindVertexArray ( obj->vao );
  glDrawElements ( GL_TRIANGLES, 3*N1, obj->index_type, (GLvoid*)0 );
  ChooseMaterial ( mat, obj->mat0+1 );
  glDrawElements ( GL_TRIANGLES, 3*(obj->ntr-N1), obj->index_type,
                   (GLvoid*)(3*N1*sizeof(GLushort)) );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawGalleon" );
} /*DrawGalleon*/

