#version 450 core

in FVertex {
  vec3      Position;
  vec2      TxtCoord;
  vec3      Normal;
  flat vec3 TNormal;
} In;

layout(location=0) out vec4 pos;
layout(location=1) out vec4 normal;
layout(location=2) out vec4 tnormal;
layout(location=3) out vec2 txtcoord;
layout(location=4) out int  matnum;

uniform MatBlock {
    int mtn;
  } mat;

void main ( void )
{
  pos = vec4 ( In.Position, 1.0 );
  normal = vec4 ( In.Normal, gl_FragCoord.z );
  tnormal = vec4 ( In.TNormal, gl_FragCoord.z );
  txtcoord = In.TxtCoord;
  matnum = mat.mtn;
} /*main*/

