#version 450 core

#define MAX_TEXTURES   4
#define MAX_MATERIALS 20
#define MAX_NLIGHTS    8

in FVertex {
  vec3      Position;
  vec2      TxtCoord;
  vec3      Normal;
  flat vec3 TNormal;
} In;

layout(binding=0) uniform sampler2D tex[MAX_TEXTURES];

layout(binding=MAX_TEXTURES) uniform sampler2D shtex[MAX_NLIGHTS];
layout(binding=MAX_TEXTURES) uniform samplerCube cshtex[MAX_NLIGHTS];

out vec4 out_Colour;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

struct LSPar {
    vec3 ambient;
    vec3 direct;
    vec4 position;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask, slmask;     /* maska wlaczonych zrodel i maska zrodel powierzchniowych */
    uint  shmask, cshmask;
    float max_depth;
    int   lightn;
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

struct Material {
    vec4  emission0, emission1;
    vec4  diffref;
    vec4  specref;
    float shininess, wa, we;
    int   txtnum;
  };

uniform MatBlock {
    int mtn;
    Material mat[MAX_MATERIALS];
  } mat;

Material m;

float CubeDepth ( vec3 v )
{
  v = abs ( v );
  if ( v.x >= v.y ) {
    if ( v.x >= v.z )    return v.x;
    else                 return v.z;
  }
  else if ( v.y >= v.z ) return v.y;
  else                   return v.z;
} /*CubeDepth*/

float IsEnlightedCube ( vec3 pos, uint l )
{
  int   k;
  vec3  lmp;
  float depth;

  depth = CubeDepth ( lmp = pos-light.ls[l].position.xyz ) /
          light.max_depth;
  return float ( depth <= texture ( cshtex[l], lmp ).r );
} /*IsEnlightedCube*/

float IsEnlighted ( uint l )
{
  vec4 pos;

  pos = light.ls[l].shadow_vpm * vec4 ( In.Position, 1.0 );
  pos.xyz /= pos.w;
  return float ( pos.z <= texture ( shtex[l], pos.xy ).r );
} /*IsEnlighted*/

vec3 posDifference ( vec4 p, vec3 pos, out float dist )
{
  vec3 v;

  if ( p.w != 0.0 ) {
    v = p.xyz/p.w-pos.xyz;
    dist = sqrt ( dot ( v, v ) );
  }
  else
    v = p.xyz;
  return normalize ( v );
} /*posDifference*/

float attFactor ( vec3 att, float dist )
{
  return 1.0/(((att.z*dist)+att.y)*dist+att.x);
} /*attFactor*/

vec3 MatEmission ( float cosnv )
{
  if ( cosnv > 0.0 )
    return m.emission1.rgb * pow ( cosnv, m.emission1.a ) + m.emission0.rgb;
  else
    return m.emission0.rgb;
} /*MatEmission*/

vec3 LambertLighting ( void )
{
  vec3  normal, tnormal, lv, vv, Colour;
  float s, d, e, dist;
  uint  i, mask;

  normal = normalize ( In.Normal );
  tnormal = In.TNormal;
  vv = posDifference ( trb.eyepos, In.Position, dist );
  e = dot ( vv, tnormal );
  Colour = MatEmission ( dot ( normal, vv ) );
  for ( i = 0, mask = 0x00000001;  i < light.nls;  i++, mask <<= 1 )
    if ( (light.mask & mask) != 0 ) {
      Colour += light.ls[i].ambient * m.diffref.xyz;
      if ( (light.shmask & mask) != 0 )
        s = IsEnlighted ( i );
      else if ( (light.cshmask & mask) != 0 )
        s = IsEnlightedCube ( In.Position, i );
      else
        s = 1.0;
      if ( s == 0.0 )
        continue;
      lv = posDifference ( light.ls[i].position, In.Position, dist );
      d = dot ( lv, normal );
      if ( e > 0.0 ) {
        if ( d > 0.0 ) {
          if ( light.ls[i].position.w != 0.0 )
            d *= attFactor ( light.ls[i].attenuation, dist );
          Colour += (s*d * light.ls[i].direct) * m.diffref.rgb;
        }
      }
      else {
        if ( d < 0.0 ) {
          if ( light.ls[i].position.w != 0.0 )
            d *= attFactor ( light.ls[i].attenuation, dist );
          Colour -= (s*d * light.ls[i].direct) * m.diffref.rgb;
        }
      }
    }
  return clamp ( Colour, 0.0, 1.0 );
} /*LambertLighting*/

#define AGamma(colour) pow ( colour, vec3(256.0/563.0) )

void main ( void )
{
  m = mat.mat[mat.mtn];
  if ( m.txtnum >= 0 )
    m.diffref = texture ( tex[m.txtnum], In.TxtCoord );
  out_Colour = vec4 ( AGamma ( LambertLighting () ), 1.0 );
} /*main*/

