#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "myscene.h"
#include "chair.h"

#define ALPHA 0.20868
#define TA    0.21176
#define SA    0.20717
#define CA    0.97830
#define LTH   0.038
#define Z0    0.0
#define Z1    0.48
#define Z2    0.85
#define Z3    (Z2+LTH*SA)
#define X0    0.0
#define X1    (X0+LTH/CA)
#define X2    (X0+Z1*TA)
#define X3    (X2+LTH/CA)
#define X4    (X2-(Z2-Z1)*TA)
#define X5    (X4+LTH*CA)
#define Y1    0.175
#define Y0    (Y1-LTH)
#define Y3    0.235
#define Y2    (Y3-LTH)
#define X7    0.51
#define X6    (X7-LTH)
#define Y5    0.235
#define Y4    (Y5-LTH)
#define Y6    (Y1-0.01)
#define Y7    (Y5-0.01)
#define Z4    0.38
#define Z5    0.45
#define X8    (X1+Z4*TA)
#define X9    (X1+Z5*TA)
#define X10   (X8-0.03)
#define X11   (X9-0.03)
#define X12   (X7-0.01)
#define Z6    (Z1+0.01)
#define X13   (X3+0.08)
#define X14   (X7-0.12)
#define Y8    (Y1-0.08)
#define Y9    (Y3-0.08)
#define BH    0.23
#define Y10   (0.3333*Y0)
#define X15   (X5-0.015*CA)
#define X16   (X4-0.015*CA)
#define X17   (X5+SA*BH)
#define X18   (X4+SA*BH)
#define X19   (X15+SA*BH)
#define X20   (X16+SA*BH)
#define Z7    (Z3-0.015*SA)
#define Z8    (Z2-0.015*SA)
#define Z9    (Z3-CA*BH)
#define Z10   (Z2-CA*BH)
#define Z11   (Z7-CA*BH)
#define Z12   (Z8-CA*BH)

#define NVERT    88
#define NTRIANG 126
#define N0       18
#define N1       36
#define N2       52
#define N3       70

static GLfloat vertpos[NVERT][3] = {
  {X0,-Y1,Z0},{X1,-Y1,Z0},{X2,-Y1,Z1},{X3,-Y1,Z1},{X4,-Y1,Z2},{X5,-Y1,Z3},
  {X0,-Y0,Z0},{X1,-Y0,Z0},{X2,-Y0,Z1},{X3,-Y0,Z1},{X4,-Y0,Z2},{X5,-Y0,Z3},
  /* 12 */
  {X0,Y0,Z0},{X1,Y0,Z0},{X2,Y0,Z1},{X3,Y0,Z1},{X4,Y0,Z2},{X5,Y0,Z3},
  {X0,Y1,Z0},{X1,Y1,Z0},{X2,Y1,Z1},{X3,Y1,Z1},{X4,Y1,Z2},{X5,Y1,Z3},
  /* 24 */
  {X6,-Y5,Z0},{X7,-Y5,Z0},{X7,-Y4,Z0},{X6,-Y4,Z0},
  {X6,-Y5,Z5},{X7,-Y5,Z5},{X7,-Y4,Z5},{X6,-Y4,Z5},
  /* 32 */
  {X6,Y4,Z0},{X7,Y4,Z0},{X7,Y5,Z0},{X6,Y5,Z0},
  {X6,Y4,Z5},{X7,Y4,Z5},{X7,Y5,Z5},{X6,Y5,Z5},
  /* 40 */
  {X8,-Y0,Z4},{X6,-Y2,Z4},{X6,Y2,Z4},{X8,Y0,Z4},
  {X8,-Y6,Z4},{X6,-Y7,Z4},{X12,-Y2,Z4},{X12,Y2,Z4},
  /* 48 */
  {X6,Y7,Z4},{X8,Y6,Z4},{X10,Y0,Z4},{X10,-Y0,Z4},
  {X9,-Y6,Z5},{X6,-Y7,Z5},{X12,-Y2,Z5},{X12,Y2,Z5},
  {X6,Y7,Z5},{X9,Y6,Z5},{X11,Y0,Z5},{X11,-Y0,Z5},
  /* 60 */
  {X7,-Y2,Z5},{X7,Y2,Z5},{X6,Y3,Z5},{X9,Y1,Z5},{X9,-Y1,Z5},{X6,-Y3,Z5},
  /* 66 */
  {X7,Y3,Z1-0.01},{X11,Y1,Z1-0.015},{X11,-Y1,Z1-0.015},{X7,-Y3,Z1-0.01},
  /* 70 */
  {X14,Y9,Z6},{X13,Y8,Z6},{X13,-Y8,Z6},{X14,-Y9,Z6},{X6,-Y5,Z1},{X6,Y5,Z1},
  /* 76 */
  {X15,-Y10,Z7},{X15,Y10,Z7},{X17,-Y0,Z9},{X19,-Y10,Z11},{X19,Y10,Z11},{X17,Y0,Z9},
  {X18,-Y0,Z10},{X20,-Y10,Z12},{X20,Y10,Z12},{X18,Y0,Z10},{X16,-Y10,Z8},{X16,Y10,Z8}
  /* 88 */
  };
static GLubyte cindex[3*NTRIANG] = {
  0,1,2,  1,3,2,  2,5,4,  2,3,5,  1,7,9,  1,9,3,  3,9,11,  3,11,5,
  7,6,8,  7,8,9,  8,11,9,  8,10,11,  6,0,2,  6,2,8,  8,2,4,  8,4,10,
  4,5,11,  4,11,10,     /* prawa tylna noga */
  /* 18 */
  12,13,14,  13,15,14,  14,17,16,  14,15,17,  13,19,21,  13,21,15,
  15,21,23,  15,23,17,  19,18,20,  19,20,21,  20,23,21,  20,22,23,
  18,12,14,  18,14,20,  20,14,16,  20,16,22,  16,17,23,  16,23,22,  /* lewa tylna noga */
  /* 36 */
  24,29,28,  24,25,29,  25,30,29,  25,26,30,
  26,31,30,  26,27,31,  27,28,31,  27,24,28,  /* prawa przednia noga */
  /* 44 */
  32,37,36,  32,33,37,  33,38,37,  33,34,38,
  34,39,38,  34,35,39,  35,36,39,  35,32,36,  /* lewa przednia noga */
  /* 52 */
  40,43,42,  40,42,41,  44,40,41,  44,41,45,
  41,42,47,  41,47,46,  43,49,48,  43,48,42,  51,50,43,  51,43,40,
  52,44,45,  52,45,53,  46,47,55,  46,55,54,
  49,57,48,  57,56,48,  59,58,50,  59,50,51,  /* siedzisko od spodu */
  /* 70 */
  60,54,55,  60,55,61,  62,56,57,  62,57,63,  52,53,65,  52,65,64,
  /* 76 */
  59,67,58,  59,68,67,  69,29,38,  69,38,66,
  75,39,63,  75,63,21,  68,3,21,  68,21,67,  64,28,74,  64,74,3,
  28,29,69,  28,69,74,  66,38,39,  66,39,75,
  /* 90 */
  74,69,66,  74,66,75,  73,74,75,  73,75,70,  72,73,70,  72,70,71,
  3,72,71,  3,71,21,  3,74,73,  3,73,72,  21,71,70,  21,70,75,  /* wierzch siedziska */
  /* 102 */
  78,79,76,  78,76,11,  79,80,77,  79,77,76,  80,81,17,  80,17,77,
  82,83,79,  82,79,78,  83,84,80,  83,80,79,  84,85,81,  84,81,80,
  10,86,83,  10,83,82,  86,87,84,  86,84,83,  87,16,85,  87,85,84,
  11,76,86,  11,86,10,  76,77,87,  76,87,86,  77,17,16,  77,16,87  /* oparcie */
  /* 126 */
  };

static const GLfloat diffr0[4] = { 0.68, 0.52, 0.3, 1.0 };  /* elementy drewnianie */
static const GLfloat specr0[4] = { 0.2, 0.2, 0.2, 1.0 };

static const GLfloat diffr1[4] = { 0.15, 0.25, 0.5, 1.0 };  /* tapicerka */
static const GLfloat specr1[4] = { 0.2, 0.2, 0.2, 1.0 };

void EnterChair ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  strcpy ( obj->name, "chair" );
  obj->mat0 = SetupMaterial ( matbl, -1, diffr0, specr0,
                              5.0, 1.0, 1.0, GL_INVALID_INDEX );
  SetupMaterial ( matbl, -1, diffr1, specr1,
                  1.0, 1.0, 1.0, GL_INVALID_INDEX );
  glGenVertexArrays ( 1, &obj->vao );
  glBindVertexArray ( obj->vao );
  glGenBuffers ( 2, obj->vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER, NVERT*3*sizeof(GLfloat),
                 vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER, NTRIANG*3*sizeof(GLubyte),
                 cindex, GL_STATIC_DRAW );
  glDisableVertexAttribArray ( 1 );
  glDisableVertexAttribArray ( 2 );
  glBindVertexArray ( 0 );
  obj->redraw = DrawChair;
  obj->destroy = DestroySceneObject;
  obj->active = true;
  obj->nvert = NVERT;  obj->ntr = NTRIANG;
  BeginEnteringObjTriangles ( belem, obj, 0, NVERT, NTRIANG, CHAIR_ELD );
  EnterTriangles ( belem, GL_TRIANGLES, NVERT, vertpos, NULL,
                   3*N0, GL_UNSIGNED_BYTE, cindex, obj->mat0, false );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   3*(N1-N0), GL_UNSIGNED_BYTE, &cindex[3*N0], obj->mat0, false );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   3*(N2-N1), GL_UNSIGNED_BYTE, &cindex[3*N1], obj->mat0, false );
  EnterTriangles ( belem, GL_TRIANGLES, 0, vertpos, NULL,
                   3*(N3-N2), GL_UNSIGNED_BYTE, &cindex[3*N2], obj->mat0, false );
  EnterTriangles ( belem, GL_TRIANGLES, 0, NULL, NULL,
                   3*(NTRIANG-N3), GL_UNSIGNED_BYTE, &cindex[3*N3], obj->mat0+1, false );
  EndEnteringObjTriangles ( belem );
  M4x4Translatef ( obj->mm, 0.0, 0.0, FLOOR_Z );
  ExitIfGLError ( "EnterChair" );
} /*EnterChair*/

void SetChairPosition ( SceneObject *obj, float x, float y, double alpha )
{
  M4x4RotateZf ( obj->mm, alpha );
  M4x4TranslateMf ( obj->mm, x, y, FLOOR_Z );
} /*SetChairPosition*/

void DrawChair ( GLuint prog_id, SceneObject *obj, TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glBindVertexArray ( obj->vao );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawElements ( GL_TRIANGLES, N3*3, GL_UNSIGNED_BYTE, (GLvoid*)0 );
  ChooseMaterial ( mat, obj->mat0+1 );
  glDrawElements ( GL_TRIANGLES, (NTRIANG-N3)*3,
                   GL_UNSIGNED_BYTE, (GLvoid*)(N3*3) );
  glBindVertexArray ( 0 );
} /*DrawChair*/

