#version 450 core

#define NVIEWPORTS 10

layout(triangles,invocations=NVIEWPORTS) in;
layout(triangle_strip,max_vertices=3) out;

in vec2 BTexCoord[];
out vec2 BTxCoord;

uniform FFTransBlock {
    mat4 mm;
    mat4 vpm[NVIEWPORTS];
  } fftr;

void main ( void )
{
  int i, j;

  j = gl_InvocationID;
  for ( i = 0; i < 3; i++ ) {
    gl_ViewportIndex = j;
    gl_Position = fftr.vpm[j] * gl_in[i].gl_Position;
    BTxCoord = BTexCoord[i];
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

