#version 450 core

#define RESTART_IND_UINT 0xFFFFFFFF

layout(early_fragment_tests) in;

in vec2 BTxCoord;

layout(location=0) out uint mel;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;   
layout(std430,binding=9) buffer VMapBuf { uvec2 px[]; } vmap;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  int  z;
  uint v;

  z = int(BTxCoord.y)*ctl.width + int(BTxCoord.x);
  v = vmap.px[z].x;
  if ( (v = vmap.px[z].x) != RESTART_IND_UINT )
    mel = vbuf.tvar[v].x;
  else
    discard;
} /*main*/

