#version 450 core

layout(location=0) in vec4 in_MPosition;
layout(location=1) in vec2 TxtCoord;
layout(location=2) in vec2 in_VPosition;

out GVertex {
    vec3 WPosition;
    vec2 TexCoord;
  } Out;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  Out.WPosition = (trb.mm * in_MPosition).xyz;
  Out.TexCoord = TxtCoord;
  gl_Position = vec4 ( 2.0*in_VPosition.x/ctl.width-1.0,
                       2.0*in_VPosition.y/ctl.height-1.0, 0.0, 1.0 );
} /*main*/

