#version 450 core

flat out int patchID;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

struct PatchRect {
    float w, h, x0, y0;
    int   melw, melh;
    int   objID;
  };

layout(std430,binding=3) buffer Pr { PatchRect pr[]; } pr;

void main ( void )
{
  vec2 vertex;
  int  id;

  patchID = id = gl_InstanceID;
  switch ( gl_VertexID ) {
 case 0: vertex = vec2 ( pr.pr[id].x0, pr.pr[id].y0 );                   break;
 case 1: vertex = vec2 ( pr.pr[id].x0+pr.pr[id].w, pr.pr[id].y0 );       break;
 case 2: vertex = vec2 ( pr.pr[id].x0, pr.pr[id].y0+pr.pr[id].h );       break;
default: vertex = vec2 ( pr.pr[id].x0+pr.pr[id].w, pr.pr[id].y0+pr.pr[id].h );
    break;
  }
  gl_Position = vec4 ( 2.0*vertex.x/ctl.width-1.0,
                       2.0*vertex.y/ctl.height-1.0, 0.0, 1.0 );
} /*main*/

