#version 450 core

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in  vec2 TexCoord[];
out vec2 TxtCoord;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

const vec2 txtc[3] = {vec2(1.0,0.0),vec2(0.0,1.0),vec2(0.0,0.0)};

void main ( void )
{
  int i;

  for ( i = 0; i < 3; i++ ) {
    if ( ctl.txts == 0 )
      TxtCoord = TexCoord[i];
    else
      TxtCoord = txtc[i];
    gl_PrimitiveID = gl_PrimitiveIDIn;
    gl_Position = gl_in[i].gl_Position;
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

