#version 440

#define LGT 0.02

layout(triangles) in;
layout(line_strip,max_vertices=2) out;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

void main ( void )
{
  vec3 v1, v2, nv, p;

  v1 = gl_in[1].gl_Position.xyz - gl_in[0].gl_Position.xyz;
  v2 = gl_in[2].gl_Position.xyz - gl_in[0].gl_Position.xyz;
  nv = normalize ( cross ( v1, v2 ) );
  p = (gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz +
       gl_in[2].gl_Position.xyz)/3.0;
  gl_Position = trb.vpm * vec4(p,1.0);
  EmitVertex ();
  p += LGT * nv;
  gl_Position = trb.vpm * vec4(p,1.0);
  EmitVertex ();
  EndPrimitive ();
} /*main*/
