#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h"
#include <GLFW/glfw3.h>

#include "../utilities/utilities.h"
#include "app4.h"
#include "app4proc.h"

#define STATE_NOTHING  0
#define STATE_TURNING1 1
#define STATE_TURNING2 2

GLFWwindow *mywindow;
double     last_xi, last_eta;
int        app_state = STATE_NOTHING;
char       redraw;
int        opti = 0;

void myGLFWErrorHandler ( int error, const char *description )
{
  fprintf ( stderr, "GLFW error: %s\n", description );
  exit ( 1 );
} /*myGLFWErrorHandler*/

void ReshapeFunc ( GLFWwindow *win, int width, int height )
{
  ResizeMyWorld ( width, height );
  redraw = true;;
  opti = 4;
} /*ReshapeFunc*/

void DisplayFunc ( GLFWwindow *win )
{
  redraw = true;
} /*DisplayFunc*/

void Redraw ( GLFWwindow *win )
{
  if ( opti > 0 ) {
    opti --;
    glfwPostEmptyEvent ();
  }
  else {
    RedrawMyWorld ();
    redraw = false;
  }
  glfwSwapBuffers ( win );
} /*Redraw*/

void KeyboardFunc ( GLFWwindow *win, int key, int scancode, int action, int mods )
{
  if ( action == GLFW_PRESS || action == GLFW_REPEAT ) {
    switch ( key ) {
  case GLFW_KEY_ESCAPE:
      glfwSetWindowShouldClose ( win, 1 );
      break;
  case GLFW_KEY_UP:
      redraw |= MoveViewer ( MOVE_UP );
      break;
  case GLFW_KEY_DOWN:
      redraw |= MoveViewer ( MOVE_DOWN );
      break;
  case GLFW_KEY_LEFT:
      redraw |= MoveViewer ( MOVE_LEFT );
      break;
  case GLFW_KEY_RIGHT:
      redraw |= MoveViewer ( MOVE_RIGHT );
      break;
  default:
      break;
    }
  }
} /*KeyboardFunc*/

void CharFunc ( GLFWwindow *win, unsigned int charcode )
{
  switch ( charcode ) {
default:
    redraw = ProcessCharCommand ( charcode );
    break;
  }
} /*CharFunc*/

void MouseFunc ( GLFWwindow *win, int button, int action, int mods )
{
  switch ( app_state ) {
case STATE_NOTHING:
    if ( button == GLFW_MOUSE_BUTTON_LEFT && action == GLFW_PRESS ) {
      glfwGetCursorPos ( win, &last_xi, &last_eta );
      app_state = STATE_TURNING1;
    }
    else if ( button == GLFW_MOUSE_BUTTON_RIGHT && action == GLFW_PRESS ) {
      glfwGetCursorPos ( win, &last_xi, &last_eta );
      app_state = STATE_TURNING2;
    }

    break;
case STATE_TURNING1:
    if ( button == GLFW_MOUSE_BUTTON_LEFT && action != GLFW_PRESS )
      app_state = STATE_NOTHING;
    break;
case STATE_TURNING2:
    if ( button == GLFW_MOUSE_BUTTON_RIGHT && action != GLFW_PRESS )
      app_state = STATE_NOTHING;
    break;
default:
    break;
  }
} /*MouseFunc*/

void MotionFunc ( GLFWwindow *win, double x, double y )
{
  switch ( app_state ) {
case STATE_TURNING1:
case STATE_TURNING2:
    if ( x != last_xi || y != last_eta ) {
      RotateViewer ( x-last_xi, y-last_eta, app_state == STATE_TURNING2 );
      last_xi = x,  last_eta = y;
      redraw = true;
    }
    break;
default:
    break;
  }
} /*MotionFunc*/

void ScrollFunc ( GLFWwindow *win, double x, double y )
{
/*  printf ( "scrollfunc: x = %f, y = %f\n", x, y );*/
  if ( y != 0.0 ) {
    if ( glfwGetMouseButton ( mywindow, GLFW_MOUSE_BUTTON_LEFT ) ==
           GLFW_PRESS )
      redraw |= MoveViewer ( y > 0.0 ? MOVE_FORWARD : MOVE_BACK );
    else
      redraw |= ChangeZoom ( y > 0.0 );
  }
} /*ScrollFunc*/

char ProcessWorldRequest ( int msg, void *data, void *reply )
{
  switch ( msg ) {
case WMSG_SET_TITLE:
    glfwSetWindowTitle ( mywindow, (char*)data );
    return true;
default:
    return false;
  }
} /*ProcessWorldRequest*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glfwDestroyWindow ( mywindow );
} /*Cleanup*/

void Initialise ( int argc, char **argv )
{
  glfwSetErrorCallback ( myGLFWErrorHandler );
  if ( !glfwInit () )
    ExitOnError ( "glfwInit failed." );
  glfwWindowHint ( GLFW_SAMPLES, 8 );
  if ( !(mywindow = glfwCreateWindow ( 480, 360,
                                       "balance", NULL, NULL )) ) {
    glfwTerminate ();
    ExitOnError ( "glfwCreateWindow failed." );
  }
  glfwMakeContextCurrent ( mywindow );
  GetGLProcAddresses ( DEFERRED_MAJOR, DEFERRED_MINOR );
  glfwSetFramebufferSizeCallback ( mywindow, ReshapeFunc );
  glfwSetWindowRefreshCallback ( mywindow, DisplayFunc );
  glfwSetKeyCallback ( mywindow, KeyboardFunc );
  glfwSetCharCallback ( mywindow, CharFunc );
  glfwSetMouseButtonCallback ( mywindow, MouseFunc );
  glfwSetCursorPosCallback ( mywindow, MotionFunc );
  glfwSetScrollCallback ( mywindow, ScrollFunc );
  InitMyWorld ( argc, argv, 480, 360 );
  redraw = true;
} /*Initialise*/

void MessageLoop ( void )
{
  while ( !glfwWindowShouldClose ( mywindow ) ) {
    glfwWaitEvents ();
    if ( redraw )
      Redraw ( mywindow );
  }
} /*MessageLoop*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  MessageLoop ();
  Cleanup ();
  glfwTerminate ();
  exit ( 0 );
} /*main*/
