
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/xwidgets.h"
#include "knotswidget.h"
#include "xknotswidget.h"

#define XWP_KW_COLOUR         XWP_GREY_25
#define XWP_ACTIVE_KW_COLOUR  XWP_GREY_10
#define XWP_AXIS              XWP_GREY_75

int KnotsWidgetXtoXi ( KnotsWidgetf *knw, float x )
{
  return (int)(knw->ximin +
               (x-knw->xmin)/(knw->xmax-knw->xmin)*(knw->ximax-knw->ximin)+0.5);
} /*KnotsWidgetXtoXi*/

float KnotsWidgetXitoX ( KnotsWidgetf *knw, int xi )
{
  return knw->xmin + (xi-knw->ximin)/(knw->ximax-knw->ximin)*(knw->xmax-knw->xmin);
} /*KnotsWidgetXitoX*/

#define XtoXi KnotsWidgetXtoXi
#define XitoX KnotsWidgetXitoX

int FindKnotInterval ( int n, float *knots, float x )
{
  int   i, j, k;

  if ( x < knots[0] )
    return -1;
  for ( i = 0, j = n;  j-i > 1; ) {
    k = i + (j-i)/2;
    if ( x < knots[k] )
      j = k;
    else
      i = k;
  }
  return i;
} /*FindKnotInterval*/

static char FindNearestKnot ( KnotsWidgetf *knw, int xi )
{
#define TOL 5
  int   i;
  float x, *knots;

  i = FindKnotInterval ( knw->nknots, knots = knw->knots, x = XitoX ( knw, xi) );
  if ( i < 0 )
    i = 0;
  if ( i < knw->nknots-1 )
    if ( x-knots[i] > knots[i+1]-x )
      i++;
  if ( fabs ( x-knots[i] )*
       (knw->ximax-knw->ximin)/(knw->xmax-knw->xmin) <= TOL ) {
    knw->current = i;
    return true;
  }
  return false;
#undef TOL
} /*FindNearestKnot*/

static void ModifyTheKnot ( int nknots, float *knots, int i )
{
#define TOL 0.02
  float x, x0, x1, h;

  x = knots[i];
  x0 = i == 0 ? x : knots[i-1];
  x1 = i == nknots-1 ? x : knots[i+1];
  h = x1-x0;
  if ( x < x0+TOL*h )      knots[i] = x0+TOL*h;
  else if ( x > x1-TOL*h ) knots[i] = x1-TOL*h;
#undef TOL
} /*ModifyTheKnot*/

static void UpdateTheKnot ( KnotsWidgetf *knw, int xi )
{
  float x, px, *knots;
  int   n, c;

  knots = knw->knots;
  x = XitoX ( knw, xi );
  px = knots[c = knw->prevc = knw->current];
  if ( x < px ) {
    while ( c > 0 && x < knots[c-1] ) {
      knots[c] = knots[c-1];
      c --;
    }
  }
  else if ( x > px ) {
    n = knw->nknots;
    while ( c < n-1 && x > knots[c+1] ) {
      knots[c] = knots[c+1];
      c ++;
    }
  }
  knots[knw->current = c] = x;
  ModifyTheKnot ( knw->nknots, knots, c );
} /*UpdateTheKnot*/

static char InsertKnot ( KnotsWidgetf *knw, int xi )
{
  float x, *knots;
  int   i;

  if ( knw->nknots >= knw->maxknots )
    return false;
  i = FindKnotInterval ( knw->nknots, knots = knw->knots, x = XitoX ( knw, xi ) );
  if ( i < knw->nknots-1 )
    memmove ( &knots[i+2], &knots[i+1], (knw->nknots-1-i)*sizeof(float) );
  knots[knw->prevc = knw->current = i+1] = x;
  ModifyTheKnot ( ++knw->nknots, knots, i+1 );
  return true;
} /*InsertKnot*/

static char DeleteTheKnot ( KnotsWidgetf *knw )
{
  float *knots;

  if ( knw->nknots > knw->minknots &&
       knw->current >= 0 && knw->current < knw->nknots ) {
    if ( knw->current < knw->nknots-1 ) {
      knots = knw->knots;
      memmove ( &knots[knw->current], &knots[knw->current+1],
                (knw->nknots-1-knw->current)*sizeof(float) );
    }
    knw->nknots --;
    return true;
  }
  return false;
} /*DeleteTheKnot*/

static char KnotsWidgetInput ( struct xwidget *wdg,
                               int msg, int key, int x, int y )
{
  KnotsWidgetf  *knw;
  xKnotsWidgetf *xknw;
  int           dxi;
  float         dx;

  xknw = (xKnotsWidgetf*)wdg;
  knw = xknw->knw;
  switch ( wdg->state ) {
case WDGSTATE_KW_MOVING_MOUSE:
    switch ( msg ) {
  case XWMSG_BUTTON_RELEASE:
      if ( key == xknw->thebutton )
        goto exit_active_state;
      break;
  case XWMSG_MOUSE_MOTION:
      knw->xc = XitoX ( knw, knw->curxi = x );
      wdg->wm->callback ( wdg, WDGMSG_KNOT_MMOVE, knw->current, x, y );
      wdg->wm->changed = true;
      break;
  default:
      break;
    }
    break;

case WDGSTATE_KW_MOVING_KNOT:
    switch ( msg ) {
  case XWMSG_BUTTON_RELEASE:
      if ( key == xknw->thebutton )
        goto exit_active_state;
      break;
  case XWMSG_MOUSE_MOTION:
      knw->xc = XitoX ( knw, knw->curxi = x );
      UpdateTheKnot ( knw, x );
      wdg->wm->callback ( wdg, WDGMSG_KNOT_CHANGE, knw->current, x, y );
      wdg->wm->changed = true;
      break;
  case XWMSG_KEY_PRESS:
      switch ( key ) {
    case 0x007f:  /* ASCII Del, not defined in keysymdef.h */
        goto delete_knot;
    default:
        break;
      }
      break;
  case XWMSG_SPECIAL_KEY_PRESS:
      switch ( key ) {
    case WDGSYS_KEY_DELETE:
delete_knot:
        if ( DeleteTheKnot ( knw ) ) {
          wdg->wm->callback ( wdg, WDGMSG_KNOT_DELETE, knw->current, x, y );
          goto exit_active_state;
        }
        break;
    default:
        break;
      }
      break;
    }
    break;

case WDGSTATE_KW_PANNING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( (dxi = x - knw->prevxi) ) {
        knw->prevxi = x;
        dx = dxi*(knw->xmax-knw->xmin)/(knw->ximax-knw->ximin);
        knw->xmin -= dx;  knw->xmax -= dx;
        wdg->wm->callback ( wdg, WDGMSG_KNOT_CHANGE_MAPPING, 0, x, y );
        wdg->wm->changed = true;
      }
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( key == xknw->thebutton )
        goto exit_active_state;
      break;
  default:
      break;
    }
    break;

case WDGSTATE_KW_ZOOMING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( (dxi = knw->prevxi - x) ) {
        knw->prevxi = x;
        dx = exp ( (float)dxi/(knw->ximax-knw->ximin) );
        knw->xmax = knw->xmin + dx*(knw->xmax-knw->xmin);
        wdg->wm->callback ( wdg, WDGMSG_KNOT_CHANGE_MAPPING, 1, x, y );
        wdg->wm->changed = true;
      }
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( key == xknw->thebutton ) {
exit_active_state:
        wdg->state = WDGSTATE_DEFAULT;
        UngrabInput ( wdg );
        wdg->wm->changed = true;
      }  
      break;
  default:
      break;
    }
    break;

default:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( !knw->motion_off ) {
        knw->xc = XitoX ( knw, knw->curxi = x );
        wdg->wm->changed = true;
      }
      break;
  case XWMSG_BUTTON_PRESS:
      knw->xc = XitoX ( knw, knw->curxi = x );
      xknw->thebutton = key;
      if ( knw->panswitch ) {
        if ( key == Button1 )
          wdg->state = WDGSTATE_KW_PANNING;
        else if ( key == Button3 )
          wdg->state = WDGSTATE_KW_ZOOMING;
        else
          break;
        goto enter_active_state;
      }
      else if ( knw->editswitch ) {
        if ( key == Button1 ) {
          wdg->wm->callback ( wdg, WDGMSG_KNOT_MCLICK, 0, x, y );
          if ( FindNearestKnot ( knw, x ) ) {
            wdg->state = WDGSTATE_KW_MOVING_KNOT;
            goto enter_active_state;
          }
          else {
            wdg->state = WDGSTATE_KW_MOVING_MOUSE;
            goto enter_active_state;
          }
        }
        else if ( key == Button3 ) {
          wdg->wm->callback ( wdg, WDGMSG_KNOT_MCLICK, 1, x, y );
          if ( InsertKnot ( knw, x ) ) {
            wdg->wm->callback ( wdg, WDGMSG_KNOT_INSERT, knw->current, x, y );
            wdg->state = WDGSTATE_KW_MOVING_KNOT;
            goto enter_active_state;
          }
        }
      }
      else {
        if ( key == Button1 ) {
          wdg->state = WDGSTATE_KW_MOVING_MOUSE;
          wdg->wm->callback ( wdg, WDGMSG_KNOT_MCLICK, 2, x, y );
enter_active_state:
          knw->prevxi = x;
          GrabInput ( wdg );
          wdg->wm->changed = true;
        }
      }
      break;
  case XWMSG_KEY_PRESS:
      switch ( key ) {
    case 'R':  case 'r':
        knw->xmin = 0.0;  knw->xmax = 10.0;
        wdg->wm->callback ( wdg, WDGMSG_KNOT_CHANGE_MAPPING, 1, x, y );
        wdg->wm->changed = true;
        break;
    case 'F':  case 'f':
        if ( knw->knots[knw->nknots-1] != knw->knots[0] ) {
          knw->xmin = knw->knots[0];  knw->xmax = knw->knots[knw->nknots-1];
          wdg->wm->callback ( wdg, WDGMSG_KNOT_CHANGE_MAPPING, 1, x, y );
          wdg->wm->changed = true;
        }
        break;
    default:
        break;
      }
      break;
  case WDGMSG_RECONFIGURE:
      if ( key )
        { wdg->r.x = x;  wdg->r.y = y; }
      else
        { wdg->r.width = x;  wdg->r.height = y; }
      knw->ximin = wdg->r.x + 3;  knw->ximax = wdg->r.x + wdg->r.width - 4;
      wdg->wm->changed = true;
    }
    break;
  }
  return true;
} /*KnotsWidgetInput*/

#ifdef __linux__
static void KnotsWidgetRedraw ( struct xwidget *wdg )
{
  KnotsWidgetf  *knw;
  xKnotsWidgetf *xknw;
  float         *knots;
  Pixmap        pm;
  int           i, n, xi, xi1, xi2;
  char          s[40];

  xknw = (xKnotsWidgetf*)wdg;
  knw = xknw->knw;
  knots = knw->knots;  n = knw->nknots;
  pm = wdg->wm->pixmap;
  if ( wdg->state != WDGSTATE_DEFAULT )
    XSetForeground ( xdisplay, xgc, XWP_ACTIVE_KW_COLOUR );
  else
    XSetForeground ( xdisplay, xgc, XWP_KW_COLOUR );
  XFillRectangle ( xdisplay, pm, xgc,
                   wdg->r.x, wdg->r.y, wdg->r.width-1, wdg->r.height-1 );
  XSetForeground ( xdisplay, xgc, XWP_GREY_75 );
  xi2 = wdg->r.x+wdg->r.width-2;
  XDrawLine ( xdisplay, wdg->wm->pixmap, xgc,
              wdg->r.x+2, wdg->r.y+15, xi2, wdg->r.y+15 );
  xi = XtoXi ( knw, knw->knots[knw->current] );
  XDrawLine ( xdisplay, wdg->wm->pixmap, xgc,
              xi, wdg->r.y+2, xi, wdg->r.y+wdg->r.height-3 );
  XSetForeground ( xdisplay, xgc, XWP_TEXT_COLOUR );
  XDrawRectangle ( xdisplay, wdg->wm->pixmap, xgc,
                   wdg->r.x, wdg->r.y, wdg->r.width-1, wdg->r.height-1 );
  xi = XtoXi ( knw, knots[0] );   if ( xi < wdg->r.x+2 ) xi = wdg->r.x+2;
  xi1 = XtoXi ( knw, knots[n-1] );  if ( xi1 > xi2 ) xi1 = xi2;
  XDrawLine ( xdisplay, pm, xgc, xi, wdg->r.y+15, xi1, wdg->r.y+15 );
  for ( i = 0; i < n; i++ ) {
    xi = XtoXi ( knw, knots[i] );
    if ( xi >= wdg->r.x+1 && xi < wdg->r.x+wdg->r.width-1 )
      XFillRectangle ( xdisplay, wdg->wm->pixmap, xgc,
                       xi-1, wdg->r.y+17, 3, 3 );
  }
  xi = XtoXi ( knw, knw->xc );
  XDrawLine ( xdisplay, wdg->wm->pixmap, xgc,
              xi, wdg->r.y+2, xi, wdg->r.y+wdg->r.height-3 );
  sprintf ( s, "%5.2f", knw->xc );
  i = strlen ( s );
  xi = xi < wdg->r.x+2 ? wdg->r.x+2 : xi;
  if ( xi > wdg->r.x+wdg->r.width-2-i*6 ) xi = wdg->r.x+wdg->r.width-2-i*6;
  XDrawString ( xdisplay, wdg->wm->pixmap, xgc,
                xi, wdg->r.y+wdg->r.height-5, s, i );
} /*KnotsWidgetRedraw*/
#endif
#ifdef _WIN32
static void KnotsWidgetRedraw ( struct xwidget *wdg )
{
  KnotsWidgetf  *knw;
  xKnotsWidgetf *xknw;
  float         *knots;
  int           i, n, xi, xi1, xi2;
  char          s[40];
  RECT          rect;
  POINT         line[2];

  xknw = (xKnotsWidgetf*)wdg;
  knw = xknw->knw;
  knots = knw->knots;  n = knw->nknots;
  if ( wdg->state != WDGSTATE_DEFAULT )
    SetDCBrushColor ( hxwdgdc, XWP_ACTIVE_KW_COLOUR );
  else
    SetDCBrushColor ( hxwdgdc, XWP_KW_COLOUR );
  XRectToWinRect ( &wdg->r, &rect );
  FillRect ( hxwdgdc, &rect, hstockbrush );
  SetDCPenColor ( hxwdgdc, XWP_GREY_75 );
  line[0].x = wdg->r.x + 2;  line[0].y = line[1].y = wdg->r.y + 15;
  line[1].x = xi2 = wdg->r.x+wdg->r.width-2;
  SelectObject ( hxwdgdc, hstockpen );
  Polyline ( hxwdgdc, line, 2 );
  xi = XtoXi ( knw, knw->knots[knw->current] );
  line[0].x = line[1].x = xi;
  line[0].y = wdg->r.y+2;  line[1].y = wdg->r.y+wdg->r.height-3;
  Polyline ( hxwdgdc, line, 2 );
  SetDCBrushColor ( hxwdgdc, XWP_TEXT_COLOUR );
  FrameRect ( hxwdgdc, &rect, hstockbrush );
  xi = XtoXi ( knw, knots[0] );   if ( xi < wdg->r.x+2 ) xi = wdg->r.x+2;
  xi1 = XtoXi ( knw, knots[n-1] );  if ( xi1 > xi2 ) xi1 = xi2;
  line[0].x = xi;   line[0].y = line[1].y = wdg->r.y+15;
  line[1].x = xi1;
  SetDCPenColor ( hxwdgdc, XWP_TEXT_COLOUR );
  Polyline ( hxwdgdc, line, 2 );
  for ( i = 0; i < n; i++ ) {
    xi = XtoXi ( knw, knots[i] );
    if ( xi >= wdg->r.x+1 && xi < wdg->r.x+wdg->r.width-1 ) {
      rect.left = xi-1;  rect.right = rect.left+3;
      rect.bottom = wdg->r.y+17;  rect.top = rect.bottom+3;
      FillRect ( hxwdgdc, &rect, hstockbrush );
    }
  }
  line[0].x = line[1].x = xi = XtoXi ( knw, knw->xc );
  line[0].y = wdg->r.y+2;  line[1].y = wdg->r.y+wdg->r.height-3;
  Polyline ( hxwdgdc, line, 2 );
  sprintf ( s, "%5.2f", knw->xc );
  i = strlen ( s );
  xi = xi < wdg->r.x+2 ? wdg->r.x+2 : xi;
  if ( xi > wdg->r.x+wdg->r.width-2-i*6 ) xi = wdg->r.x+wdg->r.width-2-i*6;
  SelectObject ( hxwdgdc, hmyfont );
  SetTextColor ( hxwdgdc, XWP_TEXT_COLOUR );
  SetBkMode ( hxwdgdc, TRANSPARENT );
  TextOutA ( hxwdgdc, xi, wdg->r.y+wdg->r.height-15, s, strlen ( s ) );
} /*KnotsWidgetRedraw*/
#endif

xKnotsWidgetf *NewKnotsWidget ( xwinmenu *wm, KnotsWidgetf *knw,
                                int id, int w, int h, int x, int y,
                                int minknots, int maxknots, int nknots,
                                float *knots, float xmin, float xmax )
{
  xKnotsWidgetf *wdg;

  wdg = (xKnotsWidgetf*)NewWidget ( wm, sizeof(xKnotsWidgetf), id, w, h, x, y,
                         KnotsWidgetInput, KnotsWidgetRedraw, NULL, NULL );
  wdg->knw = knw;
  knw->minknots = minknots;
  knw->maxknots = maxknots;
  knw->nknots = nknots;
  knw->knots = knots;
  knw->xmin = xmin;
  knw->xmax = xmax;
  knw->ximin = x+3;
  knw->ximax = x+w-4;
  knw->panswitch = knw->motion_off = false;
  return wdg;
} /*NewKnotsWidget*/

