#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "../utilities/openglheader.h"

#include "app3d.h"
#include "../utilities/utilities.h"
#include "../utilities/xwidgets.h"
#include "../utilities/initglxctx.h"
#include "knotswidget.h"
#include "xknotswidget.h"
#include "app3dproc.h"

#define WIN0_WIDTH       560
#define WIN0_HEIGHT      420
#define MENU1_WIDTH      120
#define MENU3_HEIGHT      60

#define WDGSTATE_VIEW_TURNING 1

typedef struct {
    int  last_x, last_y;
    char opti;
  } widget3d;

static Window         window[4];
static GLXContext     glxcontext;
static char           terminate;
static Atom           aAnimate;

static int            window0_width, window0_height;
static xwinmenu       *wm1, *wm2, *wm3;
static xwidget        *mywdg, *playbtn;
static AppWidgets     *appwdg;
static xKnotsWidgetf  *myknotwdg;

static char str_EXIT[]    = "Exit";
static char str_SET[]     = "Set";
static char str_LEFT[]    = "<-";
static char str_RIGHT[]   = "->";
static char str_PANZOOM[] = "pan/zoom";
static char str_EDIT[]    = "edit";

void Win1Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_BUTTON_PRESS:
    switch ( wdg->id ) {
  case BTN_ID_EXIT:
      terminate = true;
      break;
  default:
      break;
    }
    break;

case WDGMSG_SWITCH_CHANGE:
    ProcessSwitchCommand ( wdg->id );
    goto redraw_win2;

case WDGMSG_SLIDEBAR_CHANGE:
    ProcessSlidebarCommand ( wdg->id );
redraw_win2:
    wm2->changed = true;
    PostMenuExposeEvent ( wm2 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input ( mywdg, msg, key, x, y );
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win1CallBack*/

xwinmenu *SetupApp3dMenu ( void )
{
  xwinmenu *wm;
  int      i;

  if ( !(wm = NewWinMenu ( window[1], MENU1_WIDTH, WIN0_HEIGHT-MENU3_HEIGHT,
                           0, 0, NULL, NULL, Win1Callback )) )
    ExitOnError ( "SetupApp3dMenu" );
  NewButton ( wm, BTN_ID_EXIT, 60, 18, 2, 2, str_EXIT );
  for ( i = 0; i <= NPALMMESHES; i++ )
    NewSwitch ( wm, SW_ID_MESH0+i, 16, 16, 2+20*i, 22, NULL, &appwdg->sw[i] );
  for ( i = 0; i < NKLARTPARAMS; i++ )
    NewSlidebarf ( wm, SL_ID_ARTP0+i, 116, 10, 2, 46+15*i, &appwdg->artp[i] );
  return wm;
} /*SetupApp3dMenu*/

/* ////////////////////////////////////////////////////////////////////////// */
void Win0ConfigureNotify ( int width, int height )
{
  window0_width  = width;
  window0_height = height;
  XMoveResizeWindow ( xdisplay, window[1], 0, 0,
                      MENU1_WIDTH, height-MENU3_HEIGHT );
  XMoveResizeWindow ( xdisplay, window[2], MENU1_WIDTH, 0,
                      width-MENU1_WIDTH, height-MENU3_HEIGHT );
  XMoveResizeWindow ( xdisplay, window[3], 0, height-MENU3_HEIGHT,
                      width, MENU3_HEIGHT );
} /*Win0ConfigureNotify*/

void Win0MessageProc ( XEvent *ev )
{
  XClientMessageEvent *xclient;

  switch ( ev->xany.type ) {
case ConfigureNotify:
    Win0ConfigureNotify ( ev->xconfigure.width, ev->xconfigure.height );
    break;
case ClientMessage:
    xclient = (XClientMessageEvent *)ev;
    if ( xclient->message_type == WMProtocols &&
         (Atom)xclient->data.l[0] == DeleteWindow ) {
      terminate = true;
      break;
    }
default:
    break;
  }
} /*Win0MessageProc*/

/* ////////////////////////////////////////////////////////////////////////// */
void My3DWidgetRedraw ( struct xwidget *wdg )
{
  RedrawMyWorld ();
} /*My3DWidgetRedraw*/

char My3DWidgetInput ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  XClientMessageEvent *xclient;
  widget3d            *ww;

  ww = (widget3d*)wdg->data0;
  switch ( wdg->state ) {
case WDGSTATE_DEFAULT:
    switch ( msg ) {
  case XWMSG_BUTTON_PRESS:
      if ( key == Button1 ) {
        ww->last_x = x;  ww->last_y = y;
        wdg->state = WDGSTATE_VIEW_TURNING;
        GrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
      goto process_key;
  case WDGMSG_RECONFIGURE:
      ResizeMyWorld ( wdg->r.width = x, wdg->r.height = y );
      break;
  case XWMSG_CLIENT_MESSAGE:
      goto process_client_message;
  default:
      break;
    }
    break;

case WDGSTATE_VIEW_TURNING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( ((XMotionEvent*)wdg->wm->ev)->state & Button1Mask ) {
        RotateViewer ( (double)(x - ww->last_x), (double)(y - ww->last_y) );
        ww->last_x = x;  ww->last_y = y;
        wdg->wm->changed = true;
      }
      else
        goto release;
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( key == Button1 ) {
release:
        wdg->state = WDGSTATE_DEFAULT;
        UngrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
process_key:
      if ( ProcessCharCommand ( key ) )
        return wdg->wm->changed = true;
      break;
  case XWMSG_CLIENT_MESSAGE:
process_client_message:
      xclient = (XClientMessageEvent*)wdg->wm->ev;
      if ( xclient->message_type == aAnimate && appwdg->animation ) {
        if ( MoveOn () ) {
          wm1->changed = wm2->changed = wm3->changed = true;
          PostMenuExposeEvent ( wm1 );
          PostMenuExposeEvent ( wm2 );
          PostMenuExposeEvent ( wm3 );
        }
        PostClientMessageEvent ( window[2], aAnimate, 8, NULL );
      }
      break;
  default:
      break;
    }
    break;

default:
    break;
  }
  return false;
} /*My3DWidgetInput*/

xwidget *New3DWidget ( struct xwinmenu *wm, int id, int w, int h )
{
  widget3d *ww;

  if ( !(ww = malloc ( sizeof(widget3d) )) )
    ExitOnError ( "New3DWidget" );
  ww->opti = 0;
  return NewWidget ( wm, sizeof(xwidget), id, w, h, 0, 0,
                     My3DWidgetInput, My3DWidgetRedraw, ww, NULL );
} /*New3DWidget*/

void RedrawWin2 ( xwinmenu *wm )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  if ( ww->opti > 0 ) {
    ww->opti --;
    PostExposeEvent ( wm->window, wm->r.width, wm->r.height );
  }
  else
    mywdg->redraw ( mywdg );
  glXSwapBuffers ( xdisplay, wm->window );
} /*RedrawWin2*/

void Win2Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    mywdg->input ( mywdg, WDGMSG_RECONFIGURE, 0, x, y );
    ww->opti = 4;
    PostMenuExposeEvent ( wdg->wm );
    break;
case XWMSG_CLIENT_MESSAGE:
    mywdg->input ( mywdg, msg, key, x, y );
    break;
default:
    break;
  }
} /*Win2Callback*/

xwinmenu *SetupApp3dGLWindow ( void )
{
  xwinmenu *wm;

  if ( !(wm = NewWinMenu ( window[2], WIN0_WIDTH-MENU1_WIDTH,
                           WIN0_HEIGHT-MENU3_HEIGHT, 0, 0,
                           NULL, RedrawWin2, Win2Callback )) )
    ExitOnError ( "SetupApp3dGLWindow 0" );
  if ( !(mywdg = New3DWidget ( wm, GLWIN_ID_VIEW, wm->r.width, wm->r.height )) )
    ExitOnError ( "SetupApp3dGLWindow 1" );
  return wm;
} /*SetupApp3dGLWindow*/

/* ////////////////////////////////////////////////////////////////////////// */
void Win3Reshape ( xwinmenu *wm, short w, short h )
{
  myknotwdg->wdg.input ( &myknotwdg->wdg, WDGMSG_RECONFIGURE, 0,
                     w-MENU1_WIDTH, MENU3_HEIGHT-1 );
  PostExposeEvent ( wm->window, w, h );
} /*Win3Reshape*/

void Win3Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    Win3Reshape ( wdg->wm, x, y );
    break;

case WDGMSG_BUTTON_PRESS:
    wm3->changed |= ProcessButtonCommand ( wdg->id );
    break;

case WDGMSG_SWITCH_CHANGE:
    ProcessSwitchCommand ( wdg->id );
    break;

case WDGMSG_KNOT_MCLICK:
    if ( key == 0 || key == 2 ) {
      ProcessKnotWidgetCommand ( wdg->id, msg, x );
      goto let_redraw_it;
    }
    break;

case WDGMSG_KNOT_MMOVE:
case WDGMSG_KNOT_CHANGE:
case WDGMSG_KNOT_INSERT:
case WDGMSG_KNOT_DELETE:
    ProcessKnotWidgetCommand ( wdg->id, msg, x );
let_redraw_it:
    wm1->changed = wm2->changed = wm3->changed = true;
    PostMenuExposeEvent ( wm1 );
    PostMenuExposeEvent ( wm2 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input ( mywdg, msg, key, x, y );
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win3Callback*/

void MyButtonRedraw ( struct xwidget *wdg )
{
  XRectangle rect[2];
  XPoint tr[3];

  XSetForeground ( xdisplay, xgc, XWP_BUTTON_COLOUR );
  XFillRectangle ( xdisplay, wdg->wm->pixmap, xgc,
                   wdg->r.x, wdg->r.y, wdg->r.width-1, wdg->r.height-1 );
  XSetForeground ( xdisplay, xgc, XWP_TEXT_COLOUR );
  XDrawRectangle ( xdisplay, wdg->wm->pixmap, xgc,
                   wdg->r.x, wdg->r.y, wdg->r.width-1, wdg->r.height-1 );
  if ( wdg->state == WDGSTATE_DEFAULT ) {
    tr[0].x = tr[1].x = wdg->r.x+wdg->r.width/2-4;  tr[2].x = wdg->r.x+wdg->r.width/2+4;
    tr[0].y = wdg->r.y+4;  tr[1].y = wdg->r.y+wdg->r.height-4;
    tr[2].y = wdg->r.y+wdg->r.height/2;
    XFillPolygon ( xdisplay, wdg->wm->pixmap, xgc, tr, 3, Convex, CoordModeOrigin );
  }
  else {
    rect[0].width = rect[1].width = 3;
    rect[0].height = rect[1].height = wdg->r.height-8;
    rect[0].y = rect[1].y = wdg->r.y+4;
    rect[0].x = wdg->r.x+wdg->r.width/2-4;  rect[1].x = wdg->r.x+wdg->r.width/2+3;
    XFillRectangles ( xdisplay, wdg->wm->pixmap, xgc, rect, 2 );
  }
} /*MyButtonRedraw*/

xwinmenu *SetupApp3dWin3Menu ( void )
{
  KnotsWidgetf *kw;
  xwinmenu     *wm;

  if ( !(wm = NewWinMenu ( window[3], WIN0_WIDTH, MENU3_HEIGHT,
                     0, WIN0_HEIGHT-MENU3_HEIGHT, NULL, NULL, Win3Callback)) )
    ExitOnError ( "SetupApp3dWin3Menu" );
  kw = &appwdg->kw;
  myknotwdg = NewKnotsWidget ( wm, kw, KNOTWD_ID, WIN0_WIDTH-MENU1_WIDTH,
                 MENU3_HEIGHT-4, MENU1_WIDTH, 4, 4, MAXKEYFRAMES, kw->nknots,
                 kw->knots, kw->knots[0], kw->knots[kw->nknots-1] );
  kw->editswitch = true;
  kw->panswitch = kw->motion_off = false;
  NewButton ( wm, BTN_ID_LEFT, 16, 18, 0, 0, str_LEFT );
  NewButton ( wm, BTN_ID_SET, 22, 18, 19, 0, str_SET );
  NewButton ( wm, BTN_ID_RIGHT, 16, 18, 44, 0, str_RIGHT );
  playbtn = NewButton ( wm, BTN_ID_PLAY, 60, 18, 0, 20, NULL );
  playbtn->redraw = MyButtonRedraw;
  NewSwitch ( wm, SW_ID_ANIMATE_KL, 16, 16, 63, 20, NULL, &appwdg->animate_kl );
  NewSwitch ( wm, SW_ID_ANIMATE_MM, 16, 16, 82, 20, NULL, &appwdg->animate_mm );
  NewSwitch ( wm, SW_ID_ANIMATE_VP, 16, 16, 101, 20, NULL, &appwdg->animate_vp );
  NewSwitch ( wm, SW_ID_EDIT_KNOTS, 16, 16, 0, 40, str_EDIT,
              &kw->editswitch );
  NewSwitch ( wm, SW_ID_KNW_PANZOOM, 16, 16, 44, 40, str_PANZOOM,
              &kw->panswitch );
  return wm;
} /*SetupApp3dWin3Menu*/

/* ////////////////////////////////////////////////////////////////////////// */
char ProcessWorldRequest ( int msg, void *data, void *reply )
{
  switch ( msg ) {
case WMSG_ANIMATION_ON:
    PostClientMessageEvent ( window[2], aAnimate, 8, NULL );
    playbtn->state = WDGSTATE_DEFAULT+1;
    myknotwdg->knw->motion_off = true;
    return true;
case WMSG_ANIMATION_OFF:
    playbtn->state = WDGSTATE_DEFAULT;
    myknotwdg->knw->motion_off = false;
    return true;
default:
    return false;
  }
} /*ProcessWorldRequest*/

/* ////////////////////////////////////////////////////////////////////////// */
void MessageLoop ( void )
{
  XEvent ev;

  terminate = false;
  do {
    XNextEvent ( xdisplay, &ev );
    if ( ev.xany.window == window[0] )
      Win0MessageProc ( &ev );
    else if ( ev.xany.window == window[1] )
      WinMenuInput ( wm1, &ev );
    else if ( ev.xany.window == window[2] )
      WinMenuInput ( wm2, &ev );
    else if ( ev.xany.window == window[3] )
      WinMenuInput ( wm3, &ev );
  } while ( !terminate );
} /*MessageLoop*/

void InitApp3dWindows ( int argc, char **argv, int major, int minor )
{
  int visattr[] =
    { GLX_RGBA,
      GLX_DOUBLEBUFFER,
      GLX_RED_SIZE,    8,
      GLX_GREEN_SIZE,  8,
      GLX_BLUE_SIZE,   8,
      GLX_DEPTH_SIZE, 24,
      GLX_SAMPLE_BUFFERS, True,
      GLX_SAMPLES,     8,
      None };
  static const int     wx[4] = { 0, 0, MENU1_WIDTH, 0 };
  static const int     wy[4] = { 0, 0, 0, WIN0_HEIGHT-MENU3_HEIGHT };
  static const int     ww[4] = { WIN0_WIDTH, MENU1_WIDTH,
                                 WIN0_WIDTH-MENU1_WIDTH, WIN0_WIDTH };
  static const int     wh[4] = { WIN0_HEIGHT, WIN0_HEIGHT-MENU3_HEIGHT,
                                 WIN0_HEIGHT-MENU3_HEIGHT, MENU3_HEIGHT };
  Colormap             xcolormap;
  XVisualInfo          *xvii;
  XSetWindowAttributes swa;
  Window               upw;
  int                  i;

  InitGLXContext ( major, minor, 0, visattr, &xvii, &glxcontext );
  if ( !(xcolormap = XCreateColormap ( xdisplay, xrootwin,
                                       xvii->visual, AllocNone )) )
    ExitOnError ( "InitApp3dWindows 1" );
  swa.colormap = xcolormap;
  swa.event_mask = ExposureMask | StructureNotifyMask| ButtonPressMask |
                   ButtonReleaseMask | PointerMotionMask | KeyPressMask |
                   EnterWindowMask | LeaveWindowMask ;
  for ( i = 0, upw = xrootwin; i < 4; i++, upw = window[0] ) {
    window[i] = XCreateWindow ( xdisplay, upw, wx[i], wy[i], ww[i], wh[i],
                             0, xvii->depth, InputOutput, xvii->visual,
                             CWColormap | CWEventMask, &swa );
    XMapWindow ( xdisplay, window[i] );
  }
  XSetWMProtocols ( xdisplay, window[0], &DeleteWindow, 1 );
  XStoreName ( xdisplay, window[0], "Aplikacja 3D" );
  xgc = XCreateGC ( xdisplay, window[1], 0, 0 );
  aAnimate = XInternAtom ( xdisplay, "aAnimate", False );
  InitRGBXColourmap ( xvii );
  XFreeColormap ( xdisplay, xcolormap );
  XFree ( xvii );
  InitWinMenuPalette ();
  if ( !glXMakeCurrent ( xdisplay, window[2], glxcontext ) )
    ExitOnError ( "InitApp3dWindows 2" );
  GetGLProcAddresses ( 4, 5 );
  PrintGLVersion ();
  window0_width = WIN0_WIDTH;  
  window0_height = WIN0_HEIGHT;
} /*InitApp3dWindows*/

void Initialise ( int argc, char **argv )
{
  InitXServerConnection ( argc, argv, false );
  InitApp3dWindows ( argc, argv, APP3D_GL_MAJOR, APP3D_GL_MINOR );
  appwdg = InitMyWorld ( argc, argv, WIN0_WIDTH-MENU1_WIDTH,
                         WIN0_HEIGHT-MENU3_HEIGHT );
  wm1 = SetupApp3dMenu ();
  wm2 = SetupApp3dGLWindow ();
  wm3 = SetupApp3dWin3Menu ();
} /*Initialise*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  DeleteWinMenu ( wm1 );
  DeleteWinMenu ( wm2 );
  DeleteWinMenu ( wm3 );
  XDestroySubwindows ( xdisplay, window[0] );
  XDestroyWindow ( xdisplay, window[0] );
  XFreeGC ( xdisplay, xgc );
  XCloseDisplay ( xdisplay );
} /*Cleanup*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
