#version 450 core

#define MAX_NLIGHTS    8
#define MAX_MATERIALS 10

layout(early_fragment_tests) in;

in FVertex {
  vec3 Position;
  vec3 Normal, TNormal;
  vec4 ShadowPos[MAX_NLIGHTS];
} In;

out vec4 out_Colour;

uniform TransBlock {
  mat4 mm, mmti, vm, pm, vpm;
  vec4 eyepos;
} trb;

struct LSPar {
    vec4 position;
    vec3 ambient;
    vec3 direct;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask;             /* maska wlaczonych zrodel */
    uint  shmask;           /* maska tekstur cienia */
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

struct Material {
    vec4  emission0, emission1;
    vec3  diffref;    /* odbijanie rozproszone swiatla */
    vec3  specref;    /* odbijanie zwierciadlane swiatla */
    float shininess, wa, we;  /* polysk */
  };

uniform MatBlock {
    int mtn;
    Material mat[MAX_MATERIALS];
  } mat;

layout (binding = 0) uniform sampler2DShadow shtex[MAX_NLIGHTS];

uniform int LightingModel;

Material mm;
vec3     normal, tnormal;

vec3 posDifference ( vec4 p, vec3 pos, out float dist )
{
  vec3 v;

  if ( p.w != 0.0 ) {
    v = p.xyz/p.w-pos.xyz;
    dist = sqrt ( dot ( v, v ) );
  }
  else
    v = p.xyz;
  return normalize ( v );
} /*posDifference*/

float attFactor ( vec3 att, float dist )
{
  return 1.0/(((att.z*dist)+att.y)*dist+att.x);
} /*attFactor*/

vec3 MatEmission ( float cosnv )
{
  if ( cosnv > 0.0 )
    return mm.emission1.rgb * pow ( cosnv, mm.emission1.a ) + mm.emission0.rgb;
  else
    return mm.emission0.rgb;
} /*MatEmission*/

float IsEnlighted ( uint l )
{
  return textureProj ( shtex[l], In.ShadowPos[l] );
} /*IsEnlighted*/

vec3 LambertLighting ( void )
{
  vec3  lv, vv, Colour;
  float d, e, s, dist;
  uint  i, mask;

  vv = posDifference ( trb.eyepos, In.Position, dist );
  e = dot ( vv, tnormal );
  Colour = MatEmission ( dot ( normal, vv ) );
  for ( i = 0, mask = 0x00000001;  i < light.nls;  i++, mask <<= 1 )
    if ( (light.mask & mask) != 0 ) {
      Colour += light.ls[i].ambient * mm.diffref;
      s = ((light.shmask & mask) != 0) ? IsEnlighted ( i ) : 1.0;
      if ( s > 0.0 ) {
        lv = posDifference ( light.ls[i].position, In.Position, dist );
        d = dot ( lv, normal );
        if ( e > 0.0 ) {
          if ( d > 0.0 ) {
            if ( light.ls[i].position.w != 0.0 )
              d *= attFactor ( light.ls[i].attenuation, dist );
            Colour += (s*d * light.ls[i].direct) * mm.diffref;
          }
        }
        else {
          if ( d < 0.0 ) {
            if ( light.ls[i].position.w != 0.0 )
              d *= attFactor ( light.ls[i].attenuation, dist );
            Colour -= (s*d * light.ls[i].direct) * mm.diffref;
          }
        }
      }
    }
  return clamp ( Colour, 0.0, 1.0 );
} /*LambertLighting*/

float wFactor ( float lvn, float wa, float we )
{
  return 1.0+(wa-1.0)*pow ( 1.0-lvn, we );
} /*wFactor*/

vec3 BlinnPhongLighting ( void )
{
  vec3  lv, vv, hv, Colour;
  float a, d, e, f, s, dist;
  uint  i, mask;

  vv = posDifference ( trb.eyepos, In.Position, dist );
  e = dot ( vv, tnormal );
  Colour = MatEmission ( dot ( normal, vv ) );
  for ( i = 0, mask = 0x00000001;  i < light.nls;  i++, mask <<= 1 )
    if ( (light.mask & mask) != 0 ) {
      Colour += light.ls[i].ambient * mm.diffref;
      s = ((light.shmask & mask) != 0) ? IsEnlighted ( i ) : 1.0;
      if ( s > 0.0 ) {
        lv = posDifference ( light.ls[i].position, In.Position, dist );
        d = dot ( lv, normal );
        if ( e > 0.0 ) {
          if ( d > 0.0 ) {
            a = light.ls[i].position.w != 0.0 ?
                  s*attFactor ( light.ls[i].attenuation, dist ) : s;
            Colour += (a*d*light.ls[i].direct) * mm.diffref;
            hv = normalize ( lv+vv );
            f = pow ( dot ( hv, normal ), mm.shininess );
            Colour += (a*f*wFactor(d,mm.wa,mm.we))*mm.specref;
          }
        }
        else {
          if ( d < 0.0 ) {
            a = light.ls[i].position.w != 0.0 ?
                  s*attFactor ( light.ls[i].attenuation, dist ) : s;
            Colour -= (a*d*light.ls[i].direct) * mm.diffref;
            hv = normalize ( lv+vv );
            f = pow ( -dot ( hv, normal ), mm.shininess );
            Colour += (a*f*wFactor(-d,mm.wa,mm.we))*mm.specref;
          }
        }
      }
    }
  return clamp ( Colour, 0.0, 1.0 );
} /*BlinnPhongLighting*/

#define AGamma(colour) pow ( colour, vec3(256.0/563.0) )

void main ( void )
{
  vec3 Colour;

  tnormal = In.TNormal;
  normal = normalize ( In.Normal );
  mm = mat.mat[mat.mtn];
  switch ( LightingModel ) {
default: Colour = LambertLighting ();     break;
 case 1: Colour = BlinnPhongLighting ();  break;
  }
  out_Colour = vec4 ( AGamma ( Colour ), 1.0 );
} /*main*/

