#version 450 core

#define FHEMASK  0x01FFFFFF
#define TAGMASK  0x02000000
#define DEGMASK  0xFC000000
#define DEGSHIFT         26

#define V0   x
#define V1   y
#define FACN z
#define OTHE w

layout (local_size_x=1) in;

layout (std430,binding=0) buffer Inmvf { int   mvf[]; } mvf;
layout (std430,binding=1) buffer Inmhe { ivec4 mhe[]; } mhe;
layout (std430,binding=2) buffer Invc  { float vc[];  } inmvc;

layout (std430,binding=3) buffer Outvc { float vc[];  } outmvc;

uniform MeshNV {
    int innsattr, pdim, inpofs, inv, inhe, infac,
        outnsattr, outpofs, outnvofs;
  };

#define mv(I)    mvf.mvf[I]
#define mfac(I)  mvf.mvf[inv+(I)]
#define mvhei(I) mvf.mvf[inv+infac+(I)]
#define mfhei(I) mvf.mvf[inv+infac+inhe+(I)]
#define mhe(I)   mhe.mhe[I]
#define imvc(I)  inmvc.vc[I]
#define omvc(I)  outmvc.vc[I]

vec3 GetVertexPos3f ( int i )
{
  i = innsattr*i + inpofs;
  return vec3 ( imvc(i), imvc(i+1), imvc(i+2) );
} /*GetVertexPos3f*/

void MeshVertexNormal3f ( int i )
{
  int  d, fhe, j, m, f, fd, ffhe;
  vec3 p0, p1, p2, v1, v2, nv;

  fhe = mv(i) & FHEMASK;
  d = mv(i) >> DEGSHIFT;
  p0 = GetVertexPos3f ( i );
  m = outnsattr*i + outpofs;             /* copy vertex position */
  omvc(m) = p0.x;  omvc(m+1) = p0.y;  omvc(m+2) = p0.z;
  nv = vec3 ( 0.0 );
  if ( mhe(mvhei(fhe+d-1)).OTHE < 0 ) {  /* a boundary vertex */
    f = mhe(mvhei(fhe)).FACN;
    ffhe = mfac(f) & FHEMASK;
    fd = mfac(f) >> DEGSHIFT;
    for ( j = 0; j < fd; j++ )
      if ( mhe(mfhei(ffhe+j)).V1 == i )
        break;
    v1 = GetVertexPos3f ( mhe(mfhei(ffhe+j)).V0 ) - p0;
  }
  else    /* an inner vertex */
    v1 = GetVertexPos3f ( mhe(mvhei(fhe+d-1)).V1 ) - p0;
  for ( j = 0; j < d; j++ )  {
    v2 = GetVertexPos3f (  mhe(mvhei(fhe+j)).V1 ) - p0;
    nv += cross ( v1, v2 );
    v1 = v2;
  }
  nv = normalize ( nv );
  m = outnsattr*i + outnvofs;            /* store "normal vector" */
  omvc(m) = nv.x;  omvc(m+1) = nv.y;  omvc(m+2) = nv.z;
} /*MeshVertexNormal3f*/

void main ( void )
{
  switch ( pdim ) {
case 3:  MeshVertexNormal3f ( int(gl_GlobalInvocationID.x) );  break;
default: break;
  }
} /*main*/

