
#define MESHDEG         3
#define NPALMMESHES     4
#define NKLOBJ          2
#define NKLINKS        26
#define NKLREFS        27
#define NKLJOINTS      25
#define NKLARTPARAMS   21

#define NRENDERINGSHADERS 13

typedef struct {
    GLuint progid[3];
    GLint  LightingModelLoc;
  } MeshRenderPrograms;

typedef struct {
    GLuint progid[3];
    GLint  LightingModelLoc;
  } BPRenderPrograms;

typedef struct {
    GLuint progid;
    GLuint dim_loc, ncp_loc, trnum_loc;
    GLuint cpibp, cpobp, ctrbp, ctribp;
  } KLArticulationProgram;

typedef struct {
    GPUmesh *mesh[NPALMMESHES+2];
    GLfloat ecolour[3], fcolour[3];
    GLuint  tribuf, mtn;
  } KLMesh;

typedef struct {
    BezierPatchObjf *bpatches[2];
    GLuint          tribuf, mtn;
  } KLBezPatches;

typedef struct {
    int    win_width, win_height;
    float  left, right, top, bottom, near, far, rl, tb;
    float  viewer_pos0[4], viewer_rvec[3];
    double viewer_rangle;
  } Camera;

typedef struct {
    AppWidgets            wdg;
    KLMesh                palm;
    KLBezPatches          nails;
    kl_linkage            *linkage;
    Camera                camera;
    TransBl               trans;
    LightBl               light;
    MatBl                 mat;
    GLuint                lktrbuf;
    char                  lod, edges, mnv, shadows, final;
    float                 speed;
    float                 model_rot_axis[3];
    double                model_rot_angle;
    GLint                 lighting_model;
    MeshRenderPrograms    mrprog;
    BPRenderPrograms      brprog;
    KLArticulationProgram artprog;
  } AppData;


void LoadRenderingShaders ( GLuint *shader_id );
void LinkMeshRenderingPrograms ( MeshRenderPrograms *prog, GLuint *shid );
void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog );
void LinkBPRenderingPrograms ( BPRenderPrograms *brprog, GLuint *shid );
void DeleteBPRenderingPrograms ( BPRenderPrograms *prog );
void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog );

void DrawMeshEdges ( MeshRenderPrograms *prog,
                     GPUmesh *mesh, GLfloat colour[3] );
void DrawMeshFacets ( MeshRenderPrograms *prog, GPUmesh *mesh,
                      MatBl *mat, GLint mtn, char nvectors, char final );

void LoadLinkageArticulationProgram ( KLArticulationProgram *prog );
void DeleteLinkageArticulationProgram ( KLArticulationProgram *prog );
kl_linkage *ConstructPalmLinkage ( AppData *ad );
void SetArticulationParameter ( AppData *ad, int pnum );
void ArticulatePalmLinkage ( AppData *ad );

