#version 450 core

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

layout(location=0) in vec3 Normal[];
layout(location=1) in vec3 colour[];

out FVertex {
    vec3 Position;
    vec3 Colour;
    vec3 Normal, TNormal;
  } Out;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

void main ( void )
{
  int  i;
  vec4 p[3];
  vec3 q[3], nvec[3], v1, v2, tnv;

  for ( i = 0; i < 3; i++ ) {
    p[i] = trb.mm * gl_in[i].gl_Position;
    q[i] = p[i].xyz/p[i].w;
    nvec[i] = normalize ( mat3(trb.mmti) * Normal[i] );
  }
  v1 = q[1] - q[0];  v2 = q[2] - q[0];
  tnv = normalize ( cross ( v2, v1 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = trb.vpm * p[i];
    Out.Position = q[i];
    Out.Colour = colour[i];
    if ( dot ( Normal[i], Normal[i] ) < 1.0e-10 )
      Out.Normal = Out.TNormal = tnv;
    else {
      Out.Normal = nvec[i];
      Out.TNormal = dot ( nvec[i], tnv ) > 0.0 ? tnv : -tnv;
    }
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

