
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"

#include "app3a.h"
#include "../utilities/utilities.h"
#include "../utilities/GPUsparsemat.h"
#include "../utilities/meshes.h"
#include "lights.h"
#include "trans.h"
#include "app3aproc.h"
#include "app3astruct.h"

void LoadMeshRenderingPrograms ( MeshRenderPrograms *prog )
{
  static const GLchar *filename[] =
    { "app3_0.vert.glsl", "app3_0.geom.glsl", "app3_0.frag.glsl",
      "app3a_1.vert.glsl", "app3a_1.geom.glsl", "app3a_1.frag.glsl" };
  static const GLuint shtype[] =
    { GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER };
  GLuint shader_id[6];
  int    i;

  for ( i = 0; i < 6; i++ )
    shader_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  prog->progid[0] = LinkShaderProgram ( 3, &shader_id[0], "0" );
  prog->progid[1] = LinkShaderProgram ( 3, &shader_id[3], "1" );
  GetAccessToMeshSurfBlock ( prog->progid[1] );
  GetAccessToTransBlockUniform ( prog->progid[0] );
  AttachUniformTransBlockToBP ( prog->progid[1] );
  GetAccessToLightBlockUniform ( prog->progid[1] );
  for ( i = 0; i < 6; i++ )
    glDeleteShader ( shader_id[i] );
  ExitIfGLError ( "LoadMeshRenderingPrograms" );
} /*LoadMeshRenderingPrograms*/

void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog )
{
  int i;

  glUseProgram ( 0 );
  for ( i = 0; i < 2; i++ )
    glDeleteProgram ( prog->progid[i] );
  ExitIfGLError ( "DeleteMeshRenderingPrograms" );
} /*DeleteMeshRenderingPrograms*/

void DrawMeshEdges ( MeshRenderPrograms *prog,
                     GPUmesh *mesh, GLfloat colour[3] )
{
  int i;

  glUseProgram ( prog->progid[0] );
  for ( i = 0; i < 4; i++ )
    glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, i, mesh->mbuf[i] );
  SetMeshColour ( mesh, colour );
  glBindVertexArray ( empty_vao );
  glDrawArraysInstanced ( GL_LINES, 0, 2, mesh->nhe );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawMeshEdges" );
} /*DrawMeshEdges*/

void DrawMeshFacets ( MeshRenderPrograms *prog,
                      GPUmesh *mesh, GLfloat colour[3], char nvs )
{
  int i;

  for ( i = 0; i < 4; i++ )
    glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, i, mesh->mbuf[i] );
  SetMeshColour ( mesh, colour );
  SetMeshNVS ( mesh, (GLint)nvs );
  glUseProgram ( prog->progid[1] );
  glBindVertexArray ( empty_vao );
  glDrawArraysInstanced ( GL_TRIANGLE_FAN, 0, 4, mesh->nfac );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawMeshFacets" );
} /*DrawMeshFacets*/

