#include <stdlib.h>   
#include <string.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "../utilities/openglheader.h"
#include <GL/glx.h>

#include "../utilities/initglxctx.h"
#include "../utilities/utilities.h"

typedef GLXContext (*PFNGLXCREATECONTEXTATTRIBSARBPROC)
                     ( Display *dpy, GLXFBConfig config,
                       GLXContext share_context, Bool direct,
                       const int *attrib_list );

Display *xdisplay;
int     xscreen;
Window  xrootwin;
Atom    WMProtocols, DeleteWindow;

void InitXServerConnection ( int argc, char **argv, char threads )
{
  if ( threads )
    XInitThreads ();
  if ( !(xdisplay = XOpenDisplay ( "" )) )
    ExitOnError ( "InitXServerConnection 0" );
  xscreen = DefaultScreen ( xdisplay );
  xrootwin = RootWindow ( xdisplay, xscreen );
  WMProtocols = XInternAtom ( xdisplay, "WM_PROTOCOLS", False );
  DeleteWindow = XInternAtom ( xdisplay, "WM_DELETE_WINDOW", False );
} /*InitXServerConnection*/

void InitGLXContext ( int major, int minor, int flags, int *visattr,
                      XVisualInfo **xvii, GLXContext *context )
{
  PFNGLXCREATECONTEXTATTRIBSARBPROC glXCreateContextAttribsARB;
  int nelements;
  int vattr[] =
    { GLX_RGBA,         True,
      GLX_DOUBLEBUFFER, True,
      GLX_RED_SIZE,     1,
      GLX_GREEN_SIZE,   1,
      GLX_BLUE_SIZE,    1,
      GLX_DEPTH_SIZE,  24,
      None };
  int ctxattr[] =
    { GLX_CONTEXT_MAJOR_VERSION_ARB, 0,
      GLX_CONTEXT_MINOR_VERSION_ARB, 0,
      GLX_CONTEXT_PROFILE_MASK_ARB,  GLX_CONTEXT_CORE_PROFILE_BIT_ARB,
      GLX_CONTEXT_FLAGS_ARB,         0,
      None };
  GLXFBConfig *glxfbc;

  if ( !visattr )
    visattr = vattr;
  if ( !(*xvii = glXChooseVisual( xdisplay, 0, visattr )) )
    ExitOnError ( "InitGLXContext 0" );
  if ( (glXCreateContextAttribsARB =
        (PFNGLXCREATECONTEXTATTRIBSARBPROC)glXGetProcAddress
            ( (const GLubyte*)"glXCreateContextAttribsARB" )) ) {
    ctxattr[1] = major;  ctxattr[3] = minor;  ctxattr[7] = flags;
    glxfbc = glXChooseFBConfig ( xdisplay, xscreen, 0, &nelements );
    if ( !(*context = glXCreateContextAttribsARB ( xdisplay,
                                           *glxfbc, 0, 1, ctxattr )) )
      ExitOnError ( "InitGLXContext 1" );
    XFree ( glxfbc );
  }
  else
    ExitOnError ( "InitGLXContext 2" );
} /*InitGLXContext*/

/* ////////////////////////////////////////////////////////////////////////// */
void PostExposeEvent ( Window win, int width, int height )
{
  XExposeEvent ev;

  memset ( &ev, 0, sizeof(XExposeEvent) );
  ev.type = Expose;
  ev.send_event = True;
  ev.display = xdisplay;
  ev.window = win;
  ev.width = width;  ev.height = height;
  XSendEvent ( xdisplay, win, True, ExposureMask, (XEvent*)&ev );
} /*PostExposeEvent*/

void PostClientMessageEvent ( Window win, Atom message_type,
                              int format, void *data )
{
  XClientMessageEvent ev;

  memset ( &ev, 0, sizeof(XClientMessageEvent) );
  ev.type = ClientMessage;
  ev.send_event = True;
  ev.display = xdisplay;
  ev.window = win;
  ev.message_type = message_type;
  ev.format = format;
  if ( data )
    memcpy ( ev.data.b, data, 20*sizeof(char) );
  XSendEvent ( xdisplay, win, True, 0, (XEvent*)&ev );
} /*PostClientMessageEvent*/

