
typedef struct TransBl {
          GLuint  trbuf;
          GLfloat mm[16],              /* model matrix */
                  wvm0[16],
                  wvpm1[NLAYERS][16],  /* window view and projection matrices */
                  mvpm[NLAYERS][16];   /* mirror view and projection matrices */
          GLfloat eyepos0[4],
                  eyepos1[NLAYERS][4], reyepos[NLAYERS][4];
        } TransBl;


GLuint GetAccessToTransBlockUniform ( GLuint program_id );
GLuint NewUniformTransBlock ( void );
void AttachUniformTransBlockToBP ( GLuint program_id );

void LoadVPMatrices ( TransBl *trans, char mirror );
void LoadShTrans ( TransBl *trans, GLfloat vm[16], GLfloat pm[16],
                   GLfloat eyepos[4] );
void LoadMMatrix ( TransBl *trans, GLfloat mm[16] );

