#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "accumbuf.h"
#include "trans.h"

#define NTRUOFFS 4

static GLuint trbbp = GL_INVALID_INDEX;
static GLint  trbsize, trbofs[NTRUOFFS];

const GLchar *UTBNames[] =
  { "TransBlock", "TransBlock.mm", "TransBlock.mmti",
    "TransBlock.vpm", "TransBlock.eyepos" };

GLuint GetAccessToTransBlockUniform ( GLuint program_id )
{
  if ( trbbp == GL_INVALID_INDEX )
    GetAccessToUniformBlock ( program_id, NTRUOFFS, &UTBNames[0],
                              &trbsize, trbofs, &trbbp );
  else
    AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
  return trbbp;
} /*GetAccessToTransBlockUniform*/

GLuint NewUniformTransBlock ( void )
{
  return NewUniformBuffer ( trbsize, trbbp );
} /*NewUniformTransBlock*/

void AttachUniformTransBlockToBP ( GLuint program_id )
{
  AttachUniformBlockToBP ( program_id, UTBNames[0], trbbp );
} /*AttachUniformTransBlockToBP*/

void LoadVPMatrices ( TransBl *trans, char mirror )
{
  GLfloat *vpm, *ep;

  if ( mirror )
    { vpm = trans->mvpm[0];  ep = trans->reyepos[0]; }
  else
    { vpm = trans->wvpm1[0];  ep = trans->eyepos1[0]; }
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[2], NLAYERS*16*sizeof(GLfloat), vpm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[3], NLAYERS*4*sizeof(GLfloat), ep );
  ExitIfGLError ( "LoadVPMatrices" );
} /*LoadVPMatrices*/

void LoadMMatrix ( TransBl *trans, GLfloat mm[16] )
{
  GLfloat mmti[16];

  if ( mm )
    memcpy ( trans->mm, mm, 16*sizeof(GLfloat) );
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[0], 16*sizeof(GLfloat), trans->mm );
  M4x4TInvertf ( mmti, trans->mm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[1], 16*sizeof(GLfloat), mmti );
  ExitIfGLError ( "LoadMMatrix" );
} /*LoadMMatrix*/

void LoadShTrans ( TransBl *trans, GLfloat vm[16], GLfloat pm[16],
                   GLfloat eyepos[4] )
{
  GLfloat vpm[16];

  M4x4Multf ( vpm, pm, vm );
  glBindBuffer ( GL_UNIFORM_BUFFER, trans->trbuf );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[2], 16*sizeof(GLfloat), vpm );
  glBufferSubData ( GL_UNIFORM_BUFFER, trbofs[3], 4*sizeof(GLfloat), eyepos );
  ExitIfGLError ( "LoadSHTrans" );
} /*LoadShTrans*/

