#include <stdlib.h>
#include <math.h>
#include "openglheader.h"

#include "utilities.h"
#include "bezpatches.h"
#include "teapot.h"

static GLfloat teapotcp[ALT_TEAPOT_NPOINTS][3] =
 {{ 1.40000,  0.00000,  2.40000}, { 1.40000, -0.78400,  2.40000},
  { 0.78400, -1.40000,  2.40000}, { 0.00000, -1.40000,  2.40000},
  { 1.33750,  0.00000,  2.53125}, { 1.33750, -0.74900,  2.53125},
  { 0.74900, -1.33750,  2.53125}, { 0.00000, -1.33750,  2.53125},
  { 1.43750,  0.00000,  2.53125}, { 1.43750, -0.80500,  2.53125},
  { 0.80500, -1.43750,  2.53125}, { 0.00000, -1.43750,  2.53125},
  { 1.50000,  0.00000,  2.40000}, { 1.50000, -0.84000,  2.40000},
  { 0.84000, -1.50000,  2.40000}, { 0.00000, -1.50000,  2.40000},
  {-0.78400, -1.40000,  2.40000}, {-1.40000, -0.78400,  2.40000},
  {-1.40000,  0.00000,  2.40000}, {-0.74900, -1.33750,  2.53125},
  {-1.33750, -0.74900,  2.53125}, {-1.33750,  0.00000,  2.53125},
  {-0.80500, -1.43750,  2.53125}, {-1.43750, -0.80500,  2.53125},
  {-1.43750,  0.00000,  2.53125}, {-0.84000, -1.50000,  2.40000},
  {-1.50000, -0.84000,  2.40000}, {-1.50000,  0.00000,  2.40000},
  {-1.40000,  0.78400,  2.40000}, {-0.78400,  1.40000,  2.40000},
  { 0.00000,  1.40000,  2.40000}, {-1.33750,  0.74900,  2.53125},
  {-0.74900,  1.33750,  2.53125}, { 0.00000,  1.33750,  2.53125},
  {-1.43750,  0.80500,  2.53125}, {-0.80500,  1.43750,  2.53125},
  { 0.00000,  1.43750,  2.53125}, {-1.50000,  0.84000,  2.40000},
  {-0.84000,  1.50000,  2.40000}, { 0.00000,  1.50000,  2.40000},
  { 0.78400,  1.40000,  2.40000}, { 1.40000,  0.78400,  2.40000},
  { 0.74900,  1.33750,  2.53125}, { 1.33750,  0.74900,  2.53125},
  { 0.80500,  1.43750,  2.53125}, { 1.43750,  0.80500,  2.53125},
  { 0.84000,  1.50000,  2.40000}, { 1.50000,  0.84000,  2.40000},
  { 1.75000,  0.00000,  1.87500}, { 1.75000, -0.98000,  1.87500},
  { 0.98000, -1.75000,  1.87500}, { 0.00000, -1.75000,  1.87500},
  { 2.00000,  0.00000,  1.35000}, { 2.00000, -1.12000,  1.35000},
  { 1.12000, -2.00000,  1.35000}, { 0.00000, -2.00000,  1.35000},
  { 2.00000,  0.00000,  0.90000}, { 2.00000, -1.12000,  0.90000},
  { 1.12000, -2.00000,  0.90000}, { 0.00000, -2.00000,  0.90000},
  {-0.98000, -1.75000,  1.87500}, {-1.75000, -0.98000,  1.87500},
  {-1.75000,  0.00000,  1.87500}, {-1.12000, -2.00000,  1.35000},
  {-2.00000, -1.12000,  1.35000}, {-2.00000,  0.00000,  1.35000},
  {-1.12000, -2.00000,  0.90000}, {-2.00000, -1.12000,  0.90000},
  {-2.00000,  0.00000,  0.90000}, {-1.75000,  0.98000,  1.87500},
  {-0.98000,  1.75000,  1.87500}, { 0.00000,  1.75000,  1.87500},
  {-2.00000,  1.12000,  1.35000}, {-1.12000,  2.00000,  1.35000},
  { 0.00000,  2.00000,  1.35000}, {-2.00000,  1.12000,  0.90000},
  {-1.12000,  2.00000,  0.90000}, { 0.00000,  2.00000,  0.90000},
  { 0.98000,  1.75000,  1.87500}, { 1.75000,  0.98000,  1.87500},
  { 1.12000,  2.00000,  1.35000}, { 2.00000,  1.12000,  1.35000},
  { 1.12000,  2.00000,  0.90000}, { 2.00000,  1.12000,  0.90000},
  { 2.00000,  0.00000,  0.45000}, { 2.00000, -1.12000,  0.45000},
  { 1.12000, -2.00000,  0.45000}, { 0.00000, -2.00000,  0.45000},
  { 1.50000,  0.00000,  0.22500}, { 1.50000, -0.84000,  0.22500},
  { 0.84000, -1.50000,  0.22500}, { 0.00000, -1.50000,  0.22500},
  { 1.50000,  0.00000,  0.15000}, { 1.50000, -0.84000,  0.15000},
  { 0.84000, -1.50000,  0.15000}, { 0.00000, -1.50000,  0.15000},
  {-1.12000, -2.00000,  0.45000}, {-2.00000, -1.12000,  0.45000},
  {-2.00000,  0.00000,  0.45000}, {-0.84000, -1.50000,  0.22500},
  {-1.50000, -0.84000,  0.22500}, {-1.50000,  0.00000,  0.22500},
  {-0.84000, -1.50000,  0.15000}, {-1.50000, -0.84000,  0.15000},
  {-1.50000,  0.00000,  0.15000}, {-2.00000,  1.12000,  0.45000},
  {-1.12000,  2.00000,  0.45000}, { 0.00000,  2.00000,  0.45000},
  {-1.50000,  0.84000,  0.22500}, {-0.84000,  1.50000,  0.22500},
  { 0.00000,  1.50000,  0.22500}, {-1.50000,  0.84000,  0.15000},
  {-0.84000,  1.50000,  0.15000}, { 0.00000,  1.50000,  0.15000},
  { 1.12000,  2.00000,  0.45000}, { 2.00000,  1.12000,  0.45000},
  { 0.84000,  1.50000,  0.22500}, { 1.50000,  0.84000,  0.22500},
  { 0.84000,  1.50000,  0.15000}, { 1.50000,  0.84000,  0.15000},
  {-1.60000,  0.00000,  2.02500}, {-1.60000, -0.30000,  2.02500},
  {-1.50000, -0.30000,  2.25000}, {-1.50000,  0.00000,  2.25000},
  {-2.30000,  0.00000,  2.02500}, {-2.30000, -0.30000,  2.02500},
  {-2.50000, -0.30000,  2.25000}, {-2.50000,  0.00000,  2.25000},
  {-2.70000,  0.00000,  2.02500}, {-2.70000, -0.30000,  2.02500},
  {-3.00000, -0.30000,  2.25000}, {-3.00000,  0.00000,  2.25000},
  {-2.70000,  0.00000,  1.80000}, {-2.70000, -0.30000,  1.80000},
  {-3.00000, -0.30000,  1.80000}, {-3.00000,  0.00000,  1.80000},
  {-1.50000,  0.30000,  2.25000}, {-1.60000,  0.30000,  2.02500},
  {-2.50000,  0.30000,  2.25000}, {-2.30000,  0.30000,  2.02500},
  {-3.00000,  0.30000,  2.25000}, {-2.70000,  0.30000,  2.02500},
  {-3.00000,  0.30000,  1.80000}, {-2.70000,  0.30000,  1.80000},
  {-2.70000,  0.00000,  1.57500}, {-2.70000, -0.30000,  1.57500},
  {-3.00000, -0.30000,  1.35000}, {-3.00000,  0.00000,  1.35000},
  {-2.50000,  0.00000,  1.12500}, {-2.50000, -0.30000,  1.12500},
  {-2.65000, -0.30000,  0.93750}, {-2.65000,  0.00000,  0.93750},
  {-2.00000, -0.30000,  0.90000}, {-1.90000, -0.30000,  0.60000},
  {-1.90000,  0.00000,  0.60000}, {-3.00000,  0.30000,  1.35000},
  {-2.70000,  0.30000,  1.57500}, {-2.65000,  0.30000,  0.93750},
  {-2.50000,  0.30000,  1.12500}, {-1.90000,  0.30000,  0.60000},
  {-2.00000,  0.30000,  0.90000}, { 1.70000,  0.00000,  1.42500},
  { 1.70000, -0.66000,  1.42500}, { 1.70000, -0.66000,  0.60000},
  { 1.70000,  0.00000,  0.60000}, { 2.60000,  0.00000,  1.42500},
  { 2.60000, -0.66000,  1.42500}, { 3.10000, -0.66000,  0.82500},
  { 3.10000,  0.00000,  0.82500}, { 2.30000,  0.00000,  2.10000},
  { 2.30000, -0.25000,  2.10000}, { 2.40000, -0.25000,  2.02500},
  { 2.40000,  0.00000,  2.02500}, { 2.70000,  0.00000,  2.40000},
  { 2.70000, -0.25000,  2.40000}, { 3.30000, -0.25000,  2.40000},
  { 3.30000,  0.00000,  2.40000}, { 1.70000,  0.66000,  0.60000},
  { 1.70000,  0.66000,  1.42500}, { 3.10000,  0.66000,  0.82500},
  { 2.60000,  0.66000,  1.42600}, { 2.40000,  0.25000,  2.02500},
  { 2.30000,  0.25000,  2.10000}, { 3.30000,  0.25000,  2.40000},
  { 2.70000,  0.25000,  2.40000}, { 2.80000,  0.00000,  2.47500},
  { 2.80000, -0.25000,  2.47500}, { 3.52500, -0.25000,  2.49375},
  { 3.52500,  0.00000,  2.49375}, { 2.90000,  0.00000,  2.47500},
  { 2.90000, -0.15000,  2.47500}, { 3.45000, -0.15000,  2.51250},
  { 3.45000,  0.00000,  2.51250}, { 2.80000,  0.00000,  2.40000},
  { 2.80000, -0.15000,  2.40000}, { 3.20000, -0.15000,  2.40000},
  { 3.20000,  0.00000,  2.40000}, { 3.52500,  0.25000,  2.49375},
  { 2.80000,  0.25000,  2.47500}, { 3.45000,  0.15000,  2.51250},
  { 2.90000,  0.15000,  2.47500}, { 3.20000,  0.15000,  2.40000},
  { 2.80000,  0.15000,  2.40000}, { 0.00000,  0.00000,  3.15000},
  { 0.00000, -0.00200,  3.15000}, { 0.00200,  0.00000,  3.15000},
  { 0.80000,  0.00000,  3.15000}, { 0.80000, -0.45000,  3.15000},
  { 0.45000, -0.80000,  3.15000}, { 0.00000, -0.80000,  3.15000},
  { 0.00000,  0.00000,  2.85000}, { 0.20000,  0.00000,  2.70000},
  { 0.20000, -0.11200,  2.70000}, { 0.11200, -0.20000,  2.70000},
  { 0.00000, -0.20000,  2.70000}, {-0.00200,  0.00000,  3.15000},
  {-0.45000, -0.80000,  3.15000}, {-0.80000, -0.45000,  3.15000},
  {-0.80000,  0.00000,  3.15000}, {-0.11200, -0.20000,  2.70000},
  {-0.20000, -0.11200,  2.70000}, {-0.20000,  0.00000,  2.70000},
  { 0.00000,  0.00200,  3.15000}, {-0.80000,  0.45000,  3.15000},
  {-0.45000,  0.80000,  3.15000}, { 0.00000,  0.80000,  3.15000},
  {-0.20000,  0.11200,  2.70000}, {-0.11200,  0.20000,  2.70000},
  { 0.00000,  0.20000,  2.70000}, { 0.45000,  0.80000,  3.15000},
  { 0.80000,  0.45000,  3.15000}, { 0.11200,  0.20000,  2.70000},
  { 0.20000,  0.11200,  2.70000}, { 0.40000,  0.00000,  2.55000},
  { 0.40000, -0.22400,  2.55000}, { 0.22400, -0.40000,  2.55000},
  { 0.00000, -0.40000,  2.55000}, { 1.30000,  0.00000,  2.55000},
  { 1.30000, -0.72800,  2.55000}, { 0.72800, -1.30000,  2.55000},
  { 0.00000, -1.30000,  2.55000}, { 1.30000,  0.00000,  2.40000},
  { 1.30000, -0.72800,  2.40000}, { 0.72800, -1.30000,  2.40000},
  { 0.00000, -1.30000,  2.40000}, {-0.22400, -0.40000,  2.55000},
  {-0.40000, -0.22400,  2.55000}, {-0.40000,  0.00000,  2.55000},
  {-0.72800, -1.30000,  2.55000}, {-1.30000, -0.72800,  2.55000},
  {-1.30000,  0.00000,  2.55000}, {-0.72800, -1.30000,  2.40000},
  {-1.30000, -0.72800,  2.40000}, {-1.30000,  0.00000,  2.40000},
  {-0.40000,  0.22400,  2.55000}, {-0.22400,  0.40000,  2.55000},
  { 0.00000,  0.40000,  2.55000}, {-1.30000,  0.72800,  2.55000},
  {-0.72800,  1.30000,  2.55000}, { 0.00000,  1.30000,  2.55000},
  {-1.30000,  0.72800,  2.40000}, {-0.72800,  1.30000,  2.40000},
  { 0.00000,  1.30000,  2.40000}, { 0.22400,  0.40000,  2.55000},
  { 0.40000,  0.22400,  2.55000}, { 0.72800,  1.30000,  2.55000},
  { 1.30000,  0.72800,  2.55000}, { 0.72800,  1.30000,  2.40000},
  { 1.30000,  0.72800,  2.40000}, { 0.00000,  0.00000,  0.00000},
  { 1.50000,  0.00000,  0.15000}, { 1.50000,  0.84000,  0.15000},
  { 0.84000,  1.50000,  0.15000}, { 0.00000,  1.50000,  0.15000},
  { 1.50000,  0.00000,  0.07500}, { 1.50000,  0.84000,  0.07500},
  { 0.84000,  1.50000,  0.07500}, { 0.00000,  1.50000,  0.07500},
  { 1.42500,  0.00000,  0.00000}, { 1.42500,  0.79800,  0.00000},
  { 0.79800,  1.42500,  0.00000}, { 0.00000,  1.42500,  0.00000},
  {-0.84000,  1.50000,  0.15000}, {-1.50000,  0.84000,  0.15000},
  {-1.50000,  0.00000,  0.15000}, {-0.84000,  1.50000,  0.07500},
  {-1.50000,  0.84000,  0.07500}, {-1.50000,  0.00000,  0.07500},
  {-0.79800,  1.42500,  0.00000}, {-1.42500,  0.79800,  0.00000},
  {-1.42500,  0.00000,  0.00000}, {-1.50000, -0.84000,  0.15000},
  {-0.84000, -1.50000,  0.15000}, { 0.00000, -1.50000,  0.15000},
  {-1.50000, -0.84000,  0.07500}, {-0.84000, -1.50000,  0.07500},
  { 0.00000, -1.50000,  0.07500}, {-1.42500, -0.79800,  0.00000},
  {-0.79800, -1.42500,  0.00000}, { 0.00000, -1.42500,  0.00000},
  { 0.84000, -1.50000,  0.15000}, { 1.50000, -0.84000,  0.15000},
  { 0.84000, -1.50000,  0.07500}, { 1.50000, -0.84000,  0.07500},
  { 0.79800, -1.42500,  0.00000}, { 1.42500, -0.79800,  0.00000},
  {0.0,0.0,0.08}, {2.56,0.0,0.11}, {1.9,0.0,1.35},
  {2.56,-1.4336,0.11}, {1.9,-1.064,1.35},
  {1.4336,-2.56,0.11}, {1.064,-1.9,1.35},
  {0.0,-2.56,0.11}, {0.0,-1.9,1.35},
  {-1.4336,-2.56,0.11}, {-1.064,-1.9,1.35},
  {-2.56,-1.4336,0.11}, {-1.9,-1.064,1.35},
  {-2.56,0.0,0.11}, {-1.9,0.0,1.35},
  {-2.56,1.4336,0.11}, {-1.9,1.064,1.35},
  {-1.4336,2.56,0.11}, {-1.064,1.9,1.35},
  {0.0,2.56,0.11}, {0.0,1.9,1.35},
  {1.4336,2.56,0.11}, {1.064,1.9,1.35},
  {2.56,1.4336,0.11}, {1.9,1.064,1.35},
  {0.0,0.0,2.6}, {0.1,0.0,2.6}, {0.4,0.0,2.45},
  {0.1,-0.056,2.6}, {0.4,-0.224,2.45},
  {0.056,-0.1,2.6}, {0.224,-0.4,2.45},
  {0.0,-0.1,2.6}, {0.0,-0.4,2.45},
  {-0.056,-0.1,2.6}, {-0.224,-0.4,2.45},
  {-0.1,-0.056,2.6}, {-0.4,-0.224,2.45},
  {-0.1,0.0,2.6}, {-0.4,0.0,2.45},
  {-0.1,0.056,2.6}, {-0.4,0.224,2.45},
  {-0.056,0.1,2.6}, {-0.224,0.4,2.45},
  {0.0,0.1,2.6}, {0.0,0.4,2.45},
  {0.056,0.1,2.6}, {0.224,0.4,2.45},
  {0.1,0.056,2.6}, {0.4,0.224,2.45}};

static GLint teapotcn[ALT_TEAPOT_NPATCHES][16] =
  /* body */
 {{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15},
  {  3, 16, 17, 18,  7, 19, 20, 21, 11, 22, 23, 24, 15, 25, 26, 27},
  { 18, 28, 29, 30, 21, 31, 32, 33, 24, 34, 35, 36, 27, 37, 38, 39},
  { 30, 40, 41,  0, 33, 42, 43,  4, 36, 44, 45,  8, 39, 46, 47, 12},
  { 12, 13, 14, 15, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59},
  { 15, 25, 26, 27, 51, 60, 61, 62, 55, 63, 64, 65, 59, 66, 67, 68},
  { 27, 37, 38, 39, 62, 69, 70, 71, 65, 72, 73, 74, 68, 75, 76, 77},
  { 39, 46, 47, 12, 71, 78, 79, 48, 74, 80, 81, 52, 77, 82, 83, 56},
  { 56, 57, 58, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95},
  { 59, 66, 67, 68, 87, 96, 97, 98, 91, 99,100,101, 95,102,103,104},
  { 68, 75, 76, 77, 98,105,106,107,101,108,109,110,104,111,112,113},
  { 77, 82, 83, 56,107,114,115, 84,110,116,117, 88,113,118,119, 92},
    /* handle */
  {120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135},
  {123,136,137,120,127,138,139,124,131,140,141,128,135,142,143,132},
  {132,133,134,135,144,145,146,147,148,149,150,151, 68,152,153,154},
  {135,142,143,132,147,155,156,144,151,157,158,148,154,159,160, 68},
    /* spout */
  {161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176},
  {164,177,178,161,168,179,180,165,172,181,182,169,176,183,184,173},
  {173,174,175,176,185,186,187,188,189,190,191,192,193,194,195,196},
  {176,183,184,173,188,197,198,185,192,199,200,189,196,201,202,193},
    /* lid */
  {203,203,203,203,206,207,208,209,210,210,210,210,211,212,213,214},
  {203,203,203,203,209,216,217,218,210,210,210,210,214,219,220,221},
  {203,203,203,203,218,223,224,225,210,210,210,210,221,226,227,228},
  {203,203,203,203,225,229,230,206,210,210,210,210,228,231,232,211},
  {211,212,213,214,233,234,235,236,237,238,239,240,241,242,243,244},
  {214,219,220,221,236,245,246,247,240,248,249,250,244,251,252,253},
  {221,226,227,228,247,254,255,256,250,257,258,259,253,260,261,262},
  {228,231,232,211,256,263,264,233,259,265,266,237,262,267,268,241},
    /* bottom */
  {269,269,269,269,278,279,280,281,274,275,276,277, 92,119,118,113},
  {269,269,269,269,281,288,289,290,277,285,286,287,113,112,111,104},
  {269,269,269,269,290,297,298,299,287,294,295,296,104,103,102, 95},
  {269,269,269,269,299,304,305,278,296,302,303,274, 95, 94, 93, 92},
    /* body inside */
  {306,307,308,0,306,309,310,1,306,311,312,2,306,313,314,3},
  {306,313,314,3,306,315,316,16,306,317,318,17,306,319,320,18},
  {306,319,320,18,306,321,322,28,306,323,324,29,306,325,326,30},
  {306,325,326,30,306,327,328,40,306,329,330,41,306,307,308,0},
    /* lid inside */
  {331,332,333,241,331,334,335,242,331,336,337,243,331,338,339,244},
  {331,338,339,244,331,340,341,251,331,342,343,252,331,344,345,253},
  {331,344,345,253,331,346,347,260,331,348,349,261,331,350,351,262},
  {331,350,351,262,331,352,353,267,331,354,355,268,331,332,333,241}};

BezierPatchObjf* ConstructTheTeapot ( const GLfloat *colour )
{
  return EnterBezierPatchesElem ( 3, 3, 3, TEAPOT_NPATCHES, TEAPOT_NPOINTS,
                                  &teapotcp[0][0], &teapotcn[0][0], colour );
} /*ConstructTheTeapot*/

BezierPatchObjf* ConstructAltTeapot ( const GLfloat *colour )
{
  return EnterBezierPatchesElem ( 3, 3, 3, ALT_TEAPOT_NPATCHES, ALT_TEAPOT_NPOINTS,
                                  &teapotcp[0][0], &teapotcn[0][0], colour );
} /*ConstructTheTeapot*/

