#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "app2i.h"
#include "../utilities/utilities.h"
#include "../utilities/linkage.h"
#include "../utilities/bezpatches.h"
#include "../utilities/teapot.h"
#include "texture.h"
#include "trans.h"
#include "lights.h"
#include "app2istruct.h"
#include "app2iproc.h"

static AppData appdata;

void LoadBPShaders ( BPRenderPrograms *brprog )
{
  static const char *filename[] =
    { "app2g0.vert.glsl", "app2g0.tesc.glsl", "app2g0.tese.glsl",
      "app2g0.geom.glsl", "app2i1.frag.glsl", "app2g1.vert.glsl",
      "app2g1.frag.glsl", "app2g3.tese.glsl", "app2g3.frag.glsl" };
  static const GLuint shtype[] =
    { GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER,
      GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER, GL_VERTEX_SHADER,
      GL_FRAGMENT_SHADER, GL_TESS_EVALUATION_SHADER, GL_FRAGMENT_SHADER };
  static const GLchar *UVarNames[] =
    { "ColourSource", "LightingModel", "NormalSource", "ModifyDepth" };
  GLuint shader_id[9], shid[5];
  int    i;

  for ( i = 0; i < 9; i++ )
    shader_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  shid[0] = shader_id[0];  shid[1] = shader_id[1];
  shid[2] = shader_id[7];  shid[3] = shader_id[8];
  brprog->program_id[0] = LinkShaderProgram ( 4, shid, "0" );
  brprog->program_id[1] = LinkShaderProgram ( 5, shader_id, "1" );
  brprog->program_id[2] = LinkShaderProgram ( 2, &shader_id[5], "2" );
  GetAccessToTransBlockUniform ( brprog->program_id[1] );
  GetAccessToLightMatUniformBlocks ( brprog->program_id[1] );
  GetAccessToBezPatchStorageBlocks ( brprog->program_id[1], true, false );
  brprog->ColourSourceLoc =
      glGetUniformLocation ( brprog->program_id[1], UVarNames[0] );
  brprog->LightingModelLoc =
      glGetUniformLocation ( brprog->program_id[1], UVarNames[1] );
  brprog->NormalSourceLoc =
      glGetUniformLocation ( brprog->program_id[1], UVarNames[2] );
  brprog->ModifyDepthLoc =
      glGetUniformLocation ( brprog->program_id[1], UVarNames[3] );
  AttachUniformTransBlockToBP ( brprog->program_id[0] );
  AttachUniformTransBlockToBP ( brprog->program_id[2] );
  for ( i = 0; i < 9; i++ )
    glDeleteShader ( shader_id[i] );
  ExitIfGLError ( "LoadBPShaders" );
} /*LoadBPShaders*/

void _RotateViewer ( AppData *ad, double delta_xi, double delta_eta )
{
  float   vi[3], lgt, vk[3];
  double  angi, angk;

  vi[0] = (float)delta_eta*ad->camera.tb/(float)ad->camera.win_height;
  vi[1] = (float)delta_xi*ad->camera.rl/(float)ad->camera.win_width;
  vi[2] = 0.0;
  lgt = sqrt ( V3DotProductf ( vi, vi ) );
  vi[0] /= lgt;  vi[1] /= lgt;
  angi = -0.052359878;  /* -3 stopnie */
  V3CompRotationsf ( vk, &angk, ad->camera.viewer_rvec,
                     ad->camera.viewer_rangle, vi, angi );
  memcpy ( ad->camera.viewer_rvec, vk, 3*sizeof(float) );
  ad->camera.viewer_rangle = angk;
  M4x4RotateVfv ( ad->trans.wvm, ad->camera.viewer_rvec,
                  -ad->camera.viewer_rangle );
  M4x4MultMTVf ( ad->trans.eyepos, ad->trans.wvm, ad->camera.viewer_pos0 );
  M4x4InvTranslateMfv ( ad->trans.wvm, ad->camera.viewer_pos0 );
  SetupMirrorVPMatrices ( ad->trans.eyepos, ad->trans.reyepos,
                          ad->trans.mvm, ad->trans.mpm );
} /*_RotateViewer*/

void RotateViewer ( double delta_xi, double delta_eta )
{
  if ( delta_xi == 0.0 && delta_eta == 0.0 )
    return;  /* natychmiast uciekamy - nie chcemy dzielic przez 0 */
  _RotateViewer ( &appdata, (float)delta_xi, (float)delta_eta );
} /*RotateViewer*/

void InitLights ( AppData *ad )
{
  GLfloat amb0[3] = { 0.2, 0.2, 0.3 };
  GLfloat dir0[3] = { 0.8, 0.8, 0.8 };
  GLfloat pos0[4] = { -0.2, 1.0, 1.0, 0.0 };
  GLfloat atn0[3] = { 1.0, 0.0, 0.0 };
  GLfloat csc[3]  = { 0.0, 0.0, 0.0 };

  SetLightAmbient ( &ad->light, 0, amb0 );
  SetLightDirect ( &ad->light, 0, dir0 );
  SetLightPosition ( &ad->light, 0, pos0 );
  SetLightAttenuation ( &ad->light, 0, atn0 );
  SetLightOnOff ( &ad->light, 0, 1 );
  ConstructShadowTxtFBO ( &ad->light, 0 );
  SetupShadowTxtTransformations ( &ad->light, 0, csc, 2.2 );
  UpdateShadowMatrix ( &ad->light, 0 );
} /*InitLights*/

static void _ResizeMyWorld ( AppData *ad, int width, int height )
{
  float lr;

  glViewport ( 0, 0, ad->camera.win_width = width,
               ad->camera.win_height = height );
  lr = 0.5533*(float)width/(float)height;
  M4x4Frustumf ( ad->trans.wpm, NULL, ad->camera.left = -lr, ad->camera.right = lr,
                 ad->camera.bottom = -0.5533, ad->camera.top = 0.5533,
                 ad->camera.near = 5.0, ad->camera.far = 15.0 );
  ad->camera.rl = 2.0*lr;  ad->camera.tb = 2.0*0.5533;
  SetupMirrorVPMatrices ( ad->trans.eyepos, ad->trans.reyepos,
                          ad->trans.mvm, ad->trans.mpm );
} /*_ResizeMyWorld*/

void ResizeMyWorld ( int width, int height )
{
  _ResizeMyWorld ( &appdata, width, height );
} /*ResizeMyWorld*/

void InitCamera ( AppData *ad, int width, int height )
{
  static const float viewer_rvec[3] = {1.0,0.0,0.0};
  static const float viewer_pos0[4] = {0.0,0.0,10.0,1.0};

  memcpy ( ad->camera.viewer_rvec, viewer_rvec, 3*sizeof(float) );
  memcpy ( ad->camera.viewer_pos0, viewer_pos0, 4*sizeof(float) );
  memcpy ( ad->trans.eyepos, viewer_pos0, 4*sizeof(GLfloat) );
  ad->camera.viewer_rangle = 0.0;
  M4x4InvTranslatefv ( ad->trans.wvm, ad->camera.viewer_pos0 );
  _ResizeMyWorld ( ad, width, height );
} /*InitCamera*/

void InitMyWorld ( int argc, char *argv[], int width, int height )
{
  GLfloat ident_matrix[16];

  memset ( &appdata, 0, sizeof(AppData) );
  LoadBPShaders ( &appdata.brprog );
  LoadMirrorShaders ( appdata.miprog );
  LoadLinkageArticulationProgram ( &appdata.artprog );
  LoadParticleShaders ( &appdata.psprog );
  appdata.trans.trbuf = NewUniformTransBlock ();
  appdata.light.lsbuf = NewUniformLightBlock ();
  appdata.mat.matbuf = NewUniformMatBlock ();
  TimerInit ();
  M4x4Identf ( ident_matrix );
  LoadMMatrix ( &appdata.trans, ident_matrix );
  InitCamera ( &appdata, width, height );
  appdata.TessLevel = 10;
  appdata.BezNormals = GL_TRUE;
  appdata.hold_time = 0.0;
  appdata.cnet = appdata.skeleton = appdata.particles =
    appdata.animate = appdata.hold = false;
  appdata.shadows = true;
  ConstructMirror ( &appdata.mirror );
  InitLights ( &appdata );
  if ( !ConstructMyLinkage ( &appdata ) )
    ExitOnError ( "InitMyObject" );
  ArticulateMyLinkage ( appdata.linkage );
} /*InitMyWorld*/

void DrawScene ( AppData *ad, char final )
{
  DrawMyLinkage ( ad, final );
} /*DrawScene*/

void DrawSceneToMirror ( AppData *ad )
{
  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, ad->mirror.mirror_fbo );
  glViewport ( 0, 0, MIRRORTXT_W, MIRRORTXT_H );
  LoadVPMatrix ( &ad->trans, true );
  glClearColor ( 0.95, 0.95, 0.95, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  DrawScene ( ad, true );
  glFlush ();
} /*DrawSceneToMirror*/

void DrawSceneToShadows ( AppData *ad )
{
  int    l;
  GLuint mask;

  glClearColor ( 1.0, 1.0, 1.0, 1.0 );
  glViewport ( 0, 0, SHADOW_MAP_SIZE, SHADOW_MAP_SIZE );
  glEnable ( GL_POLYGON_OFFSET_FILL );
  glPolygonOffset ( 2.0f, 4.0f );
  for ( l = 0, mask = 0x00000001;  l < ad->light.nls;  l++, mask <<= 1 )
    if ( ad->light.shmask & mask ) {
      BindShadowTxtFBO ( &ad->trans, &ad->light, l );
      glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
      glColorMask ( GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE );
      LoadMMatrix ( &ad->trans, ad->mirror.mirror_matrix );
      DrawMirror ( &ad->mirror, ad->miprog[0], false );
      DrawScene ( ad, false );
    }
  glColorMask ( GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE );
  glBindFramebuffer ( GL_FRAMEBUFFER, 0 );
  glDisable ( GL_POLYGON_OFFSET_FILL );
  for ( l = 0, mask = 0x00000001;  l < ad->light.nls;  l++, mask <<= 1 )
    if ( ad->light.shmask & mask ) {
      glActiveTexture ( GL_TEXTURE2+l );
      glBindTexture ( GL_TEXTURE_2D, ad->light.ls[l].shadow_txt[0] );
      glActiveTexture ( GL_TEXTURE2+MAX_NLIGHTS+l );
      glBindTexture ( GL_TEXTURE_2D, ad->light.ls[l].shadow_txt[1] );
    }
} /*DrawSceneToShadows*/

void DrawSceneToWindow ( AppData *ad )
{
  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, 0 );
  glViewport ( 0, 0, ad->camera.win_width, ad->camera.win_height );
  LoadVPMatrix ( &ad->trans, false );
  glClearColor ( 1.0, 1.0, 1.0, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  LoadMMatrix ( &ad->trans, ad->mirror.mirror_matrix );
  DrawMirror ( &ad->mirror, ad->miprog[1], true );
  DrawScene ( ad, true );
  glFlush ();
} /*DrawSceneToWindow*/

void RedrawMyWorld ( void )
{
  if ( !appdata.hold )
    ArticulateMyLinkage ( appdata.linkage );
  glEnable ( GL_DEPTH_TEST );
  DrawSceneToShadows ( &appdata );
  DrawSceneToMirror ( &appdata );
  DrawSceneToWindow ( &appdata );
} /*RedrawMyWorld*/

void DeleteMyWorld ( void )
{
  int i;

  glUseProgram ( 0 );
  for ( i = 0; i < 3; i++ )
    glDeleteProgram ( appdata.brprog.program_id[i] );
  for ( i = 0; i < 2; i++ )
    glDeleteProgram ( appdata.miprog[i] );
  DeleteLinkageArticulationProgram ( &appdata.artprog );
  DeleteParticleShaders ( &appdata.psprog );
  glDeleteBuffers ( 1, &appdata.trans.trbuf );
  glDeleteBuffers ( 1, &appdata.light.lsbuf );
  glDeleteBuffers ( 1, &appdata.mat.matbuf );
  glDeleteBuffers ( 1, &appdata.lktrbuf );
  kl_DestroyLinkage ( appdata.linkage );
  DeleteMirror ( &appdata.mirror );
  DeleteShadowFBO ( &appdata.light );
  DeleteEmptyVAO ();
#ifdef DEBUG_BUFFERS_ALLOCATION
  DumpBufferIdentifiers ();
#endif
} /*DeleteMyWorld*/

char HoldOnOff ( AppData *ad )
{
  if ( (ad->hold = !ad->hold) ) {
    TimerToc ();
    ad->hold_time0 = app_time;
    return false;
  }
  else {
    TimerTic ();
    ad->hold_time += app_time - ad->hold_time0;
    return true;
  }
} /*HoldOnOff*/

char ProcessCharCommand ( char charcode )
{
  switch ( toupper ( charcode ) ) {
case '+':
    if ( appdata.TessLevel < MAX_TESS_LEVEL ) {
      SetBezierPatchTessLevel ( appdata.bezp[0].bpatches[0], ++appdata.TessLevel );
      SetBezierPatchTessLevel ( appdata.bezp[1].bpatches[0], appdata.TessLevel );
      return true;
    }
    else return false;
case '-':
    if ( appdata.TessLevel > MIN_TESS_LEVEL ) {
      SetBezierPatchTessLevel ( appdata.bezp[0].bpatches[0], --appdata.TessLevel );
      SetBezierPatchTessLevel ( appdata.bezp[1].bpatches[0], appdata.TessLevel );
      return true;
    }
    else return false;
case 'N':
    appdata.BezNormals = appdata.BezNormals == 0;
    SetBezierPatchNVS ( appdata.bezp[0].bpatches[0], appdata.BezNormals );
    SetBezierPatchNVS ( appdata.bezp[1].bpatches[0], appdata.BezNormals );
    return true;
case 'C':
    appdata.cnet = !appdata.cnet;
    return true;
case 'S':
    appdata.skeleton = !appdata.skeleton;
    return true;
case 'B':
    glUseProgram ( appdata.brprog.program_id[1] );
    glUniform1i ( appdata.brprog.LightingModelLoc,
          appdata.brprog.lighting_model = !appdata.brprog.lighting_model );
    return true;
case ' ':
    if ( (appdata.animate = !appdata.animate) )
      TimerTic ();
    return appdata.animate;
case '0':
    appdata.brprog.colour_source = 0;
    return true;
case '1':
    appdata.brprog.colour_source = 1;
    return true;
case '2':
    appdata.brprog.colour_source = 2;
    return true;
case 'D':
    appdata.brprog.normal_source = (appdata.brprog.normal_source+1) % 3;
    return true;
case 'M':
    appdata.brprog.modify_depth = !appdata.brprog.modify_depth;
    return true;
case 'U':
    SetShadowsOnOff ( &appdata.light, appdata.shadows = !appdata.shadows );
    return true;
case 'P':
    if ( (appdata.particles = !appdata.particles) )
      ResetParticles ( &appdata.psprog, &appdata.ps,
                       app_time-appdata.hold_time );
    return true;
case 'R':
    if ( appdata.particles )
      ResetParticles ( &appdata.psprog, &appdata.ps,
                       app_time-appdata.hold_time );
    return appdata.particles;
case 'X':
    return HoldOnOff ( &appdata );
default:
    return false;
  }
} /*ProcessCharCommand*/

char MoveOn ( void )
{
  return !appdata.hold;
} /*MoveOn*/

