
#define MIN_TESS_LEVEL  3
#define MAX_TESS_LEVEL 32

#define ANGULAR_VELOCITY1 (0.25*PI)
#define ANGULAR_VELOCITY2 (-2.0*PI)

#define MIRRORTXT_W 1024
#define MIRRORTXT_H 1024

typedef struct Camera {
    int    win_width, win_height;
    float  left, right, bottom, top, near, far, rl, tb;
    float  viewer_pos0[4];
    float  viewer_rvec[3];
    double viewer_rangle;
  } Camera;

typedef struct Mirror {
    GLuint  mirror_fbo, mirror_txt[2];
    GLuint  mirror_vao, mirror_vbo;
    GLfloat mirror_matrix[16];
  } Mirror;

typedef struct {
    GLuint program_id[2];
    GLint  ColourSourceLoc, colour_source,
           LightingModelLoc, lighting_model,
           NormalSourceLoc, normal_source,
           ModifyDepthLoc, modify_depth;
  } BPRenderPrograms;

typedef struct {
    Camera           camera;
    BezierPatchObjf  *myteapot, *mytorus;
    Mirror           mirror;
    TransBl          trans;
    LightBl          light;
    MatBl            mat;
    GLuint           mytexture;
    GLint            BezNormals, TessLevel;
    char             cnet, skeleton, animate;
    float            model_rot_axis[3];
    double           teapot_rot_angle, torus_rot_angle;
    GLfloat          teapot_mmatrix[16], torus_mmatrix[16];
    BPRenderPrograms brprog;
    GLuint           miprog;
  } AppData;


GLuint CreateMyTexture ( int wh );
char LoadMyTextureImage ( GLuint tex, int txwidth, int txheight,
                          int x, int y, const char *filename );
char SetupMyTextureMipmaps ( GLuint tex );

void LoadMirrorShaders ( GLuint *program_id );
void ConstructMirror ( Mirror *mirror );
void SetupMirrorVPMatrices ( GLfloat eyepos[4], GLfloat reyepos[4],
                             GLfloat mvm[16], GLfloat mpm[16] );
void DrawMirror ( Mirror *mirror, GLuint program_id );
void DeleteMirror ( Mirror *mirror );

