
#ifndef BEZPATCHES_H
#define BEZPATCHES_H

#define MAX_PATCH_DEGREE 10

typedef struct BezierPatchObjf {
    GLint  udeg, vdeg, dim, stride_u, stride_v, stride_p, stride_q, npatches;
    GLuint buf[5];
  } BezierPatchObjf;

void GetAccessToBezPatchStorageBlocks ( GLuint program_id,
                                        char txt, char tess );

BezierPatchObjf* EnterBezierPatches ( GLint udeg, GLint vdeg, GLint dim,
                      GLint np, GLint nq, GLint ncp, const GLfloat *cp,
                      GLint stride_p, GLint stride_q, GLint stride_u, GLint stride_v,
                      const GLfloat *colour );
BezierPatchObjf* EnterBezierPatchesElem ( GLint udeg, GLint vdeg, GLint dim,
                      int npatches, int ncp,
                      const GLfloat *cp, const GLint *ind,
                      const GLfloat *colour );

void SetBezierPatchTessLevel ( BezierPatchObjf *bp, GLint tesslevel );
void SetBezierPatchNVS ( BezierPatchObjf *bp, GLint nvs );
void SetBezierPatchColour ( BezierPatchObjf *bp, GLfloat *colour );
char GenBezierPatchTextureBlock ( BezierPatchObjf *bp, const GLfloat *data );
void BindBezPatchTextureBuffer ( BezierPatchObjf *bp );
char GenBezierPatchTessParamBlock ( BezierPatchObjf *bp );
void BindBezPatchTessParamBuffer ( BezierPatchObjf *bp );

void BindBezierPatchBuffers ( BezierPatchObjf *bp );
void DrawBezierPatches ( BezierPatchObjf *bp );
void DrawBezierNets ( BezierPatchObjf *bp );

void DeleteBezierPatches ( BezierPatchObjf *bp );

#endif
