
#define MAX_NLIGHTS    8
#define MAX_MATERIALS 10

typedef struct LSPar {
          GLfloat position[4];
          GLfloat ambient[3];
          GLfloat direct[3];
          GLfloat attenuation[3];
        } LSPar;

typedef struct LightBl {
          GLuint lsbuf;
          GLuint nls, mask;
          LSPar  ls[MAX_NLIGHTS];
        } LightBl;

typedef struct Material {
          GLfloat emission0[4], emission1[4];
          GLfloat diffref[3];
          GLfloat specref[3];
          GLfloat shininess, wa, we;
        } Material;

typedef struct MatBl {
          GLuint matbuf;
          int    nmat;
          Material mat[MAX_MATERIALS];
        } MatBl;

void GetAccessToLightMatUniformBlocks ( GLuint program_id );
void AttachUniformLightMatBlockToBP ( GLuint program_id );
GLuint NewUniformLightBlock ( void );

void SetLightAmbient ( LightBl *light, int l, GLfloat amb[3] );
void SetLightDirect ( LightBl *light, int l, GLfloat dir[3] );
void SetLightPosition ( LightBl *light, int l, GLfloat pos[4] );
void SetLightAttenuation ( LightBl *light, int l, GLfloat at3[3] );
void SetLightOnOff ( LightBl *light, int l, char on );

GLuint NewUniformMatBlock ( void ); 
int SetupMaterial ( MatBl *matbl, int m, const GLfloat diffr[3],
                    const GLfloat specr[3], GLfloat shn, GLfloat wa, GLfloat we );
void SetMaterialEmission ( MatBl *matbl, int m, const GLfloat em0[4],
                           const GLfloat em1[4] );
void ChooseMaterial ( MatBl *matbl, GLint m );

