#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "lights.h"
#include "trans.h"
#include "../utilities/mygltext.h"
#include "readsmf.h"
#include "app1f.h"
#include "app1fproc.h"

#define ANGULAR_VELOCITY (0.25*PI)

GLuint  program_id[2];
int     smf_nv, smf_ntr;
GLfloat smf_mm[16];
GLuint  smf_vao, smf_vbo[2];
int     option = 2;
char    enlight = true;
TransBl trans;
LightBl light;
int     win_width, win_height;
float   left, right, bottom, top, near, far;
float   model_rot_axis[3] = {0.0,1.0,0.0};
double  model_rot_angle = 0.0;
float   viewer_rvec[3] = {1.0,0.0,0.0};
double  viewer_rangle = 0.0;
const float viewer_pos0[4] = {0.0,0.0,10.0,1.0};
myTextObject *vptext;
myFont  *fonts[2], *font;

void LoadMyShaders ( void )
{
  static const char *filename[5] =
    { "app1b0.vert.glsl", "app1b0.frag.glsl",
      "app1b1.vert.glsl", "app1b1.geom.glsl", "app1b1.frag.glsl" };
  static const GLuint shtype[5] =
    { GL_VERTEX_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER };
  GLuint shader_id[5];
  int    i;

  for ( i = 0; i < 5; i++ )
    shader_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  program_id[0] = LinkShaderProgram ( 2, &shader_id[0], "0" );
  program_id[1] = LinkShaderProgram ( 3, &shader_id[2], "1" );
  GetAccessToTransBlockUniform ( program_id[1] );
  GetAccessToLightBlockUniform ( program_id[1] );
  AttachUniformTransBlockToBP ( program_id[0] );
  for ( i = 0; i < 5; i++ )
    glDeleteShader ( shader_id[i] );
  ExitIfGLError ( "LoadMyShaders" );
} /*LoadMyShaders*/

void SetupModelMatrix ( float axis[3], double angle )
{
  GLfloat m[16], mm[16];

  M4x4RotateVf ( m, axis[0], axis[1], axis[2], angle );
  M4x4Multf ( mm, m, smf_mm );
  LoadMMatrix ( &trans, mm );
} /*SetupModelMatrix*/

void NotifyViewerPos ( void )
{
  GLchar s[60];

  sprintf ( s, "x = %5.2f, y = %5.2f, z = %5.2f",
            trans.eyepos[0], trans.eyepos[1], trans.eyepos[2] );
  SetTextObjectContents ( vptext, s, 0, win_height-1, font );
} /*NotifyViewerPos*/

void InitViewMatrix ( void )
{
  memcpy ( trans.eyepos, viewer_pos0, 4*sizeof(GLfloat) );
  M4x4Translatef ( trans.vm, -viewer_pos0[0], -viewer_pos0[1], -viewer_pos0[2] );
  LoadVPMatrix ( &trans );
  NotifyViewerPos ();
} /*InitViewMatrix*/

void RotateViewer ( double delta_xi, double delta_eta )
{
  float   vi[3], lgt, vk[3];
  double  angi, angk;

  if ( delta_xi == 0 && delta_eta == 0 )
    return;  /* natychmiast uciekamy - nie chcemy dzielic przez 0 */
  vi[0] = (float)delta_eta*(top-bottom)/(float)win_height;
  vi[1] = (float)delta_xi*(right-left)/(float)win_width;
  vi[2] = 0.0;
  lgt = sqrt ( V3DotProductf ( vi, vi ) );
  vi[0] /= lgt;  vi[1] /= lgt;
  angi = -0.052359878;  /* -3 stopnie */
  V3CompRotationsf ( vk, &angk, viewer_rvec, viewer_rangle, vi, angi );
  memcpy ( viewer_rvec, vk, 3*sizeof(float) );
  viewer_rangle = angk;
  M4x4RotateVfv ( trans.vm, viewer_rvec, -viewer_rangle );
  M4x4MultMTVf ( trans.eyepos, trans.vm, viewer_pos0 );
  M4x4InvTranslateMfv ( trans.vm, viewer_pos0 );
  LoadVPMatrix ( &trans );
  NotifyViewerPos ();
} /*RotateViewer*/

void FindSMFMMatrix ( int smf_nv, GLfloat *vc, GLfloat smf_mm[16] )
{
  GLfloat xmin, xmax, ymin, ymax, zmin, zmax, dx, dy, dz, s;
  int     i, j;

  if ( smf_nv > 1 ) {
    xmin = xmax = vc[0];
    ymin = ymax = vc[1];
    zmin = zmax = vc[2];
    for ( i = 1, j = 3;  i < smf_nv;  i++, j += 3 ) {
      if ( vc[j] < xmin )      xmin = vc[j];
      else if ( vc[j] > xmax ) xmax = vc[j];
      if ( vc[j+1] < ymin )      ymin = vc[j+1];
      else if ( vc[j+1] > ymax ) ymax = vc[j+1];
      if ( vc[j+2] < zmin )      zmin = vc[j+2];
      else if ( vc[j+2] > zmax ) zmax = vc[j+2];
    }
    dx = 0.5*(xmax-xmin);
    dy = 0.5*(ymax-ymin);
    dz = 0.5*(zmax-zmin);
    s = dx > dy ? dx : dy;
    s = dz > s  ? dz : s;
    if ( s > 0.0 ) {
      s = 1.0/s;  M4x4Scalef ( smf_mm, s, s, s );
      M4x4MTranslatef ( smf_mm, -0.5*(xmin+xmax), -0.5*(ymin+ymax), -0.5*(zmin+zmax) );
      return;
    }
  }
  M4x4Identf ( smf_mm );
} /*FindSMFMMatrix*/

void ConstructSMFObject ( char *fn )
{
  GLfloat *vc;
  GLint   *trv;

  if ( ReadSMFFile ( fn, &smf_nv, &vc, &smf_ntr, &trv ) ) {
    glGenVertexArrays ( 1, &smf_vao );
    glBindVertexArray ( smf_vao );
    glGenBuffers ( 2, smf_vbo );
    glBindBuffer ( GL_ARRAY_BUFFER, smf_vbo[0] );
    glBufferData ( GL_ARRAY_BUFFER, smf_nv*3*sizeof(GLfloat),
                   vc, GL_STATIC_DRAW );
    glEnableVertexAttribArray ( 0 );
    glVertexAttrib4f ( 1, 0.5, 0.8, 1.0, 1.0 );
    glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                            3*sizeof(GLfloat), (GLvoid*)0 );
    glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, smf_vbo[1] );
    glBufferData ( GL_ELEMENT_ARRAY_BUFFER, 3*smf_ntr*sizeof(GLint),
                   trv, GL_STATIC_DRAW );
    FindSMFMMatrix ( smf_nv, vc, smf_mm );
    free ( vc );
    free ( trv );
    glBindVertexArray ( 0 );
    ExitIfGLError ( "ConstructSMFObject" );
  }
  else
    ExitOnError ( "Pliku nie udalo sie przeczytac" );
} /*ConstructSMFObject*/
 
void DrawSMFObject ( int option )
{
  glBindVertexArray ( smf_vao );
  switch ( option ) {
case 0:
    glPointSize ( 5.0 );
    glUseProgram ( program_id[0] );
    glDrawArrays ( GL_POINTS, 0, smf_nv );
    break;
case 1:
    glPolygonMode ( GL_FRONT_AND_BACK, GL_LINE );
    glUseProgram ( program_id[enlight ? 1 : 0] );
    glDrawElements ( GL_TRIANGLES, 3*smf_ntr, GL_UNSIGNED_INT, (GLvoid*)0 );
    break;
case 2:
    glPolygonMode ( GL_FRONT_AND_BACK, GL_FILL );
    glUseProgram ( program_id[enlight ? 1 : 0] );
    glDrawElements ( GL_TRIANGLES, 3*smf_ntr, GL_UNSIGNED_INT, (GLvoid*)0 );
    break;
default:
    break;
  }
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawSMFObject" );
} /*DrawSMFObject*/

void InitLights ( void )
{
  GLfloat amb0[3] = { 0.2, 0.2, 0.3 };
  GLfloat dir0[3] = { 0.8, 0.8, 0.8 };
  GLfloat pos0[4] = { 0.0, 1.0, 1.0, 0.0 };
  GLfloat atn0[3] = { 1.0, 0.0, 0.0 };

  SetLightAmbient ( &light, 0, amb0 );
  SetLightDirect ( &light, 0, dir0 );
  SetLightPosition ( &light, 0, pos0 );
  SetLightAttenuation ( &light, 0, atn0 );
  SetLightOnOff ( &light, 0, 1 );
} /*InitLights*/

char *InputFilename ( int argc, char *argv[] )
{
  int i;

  for ( i = 1; i < argc-1; i++ )
    if ( !strcmp ( argv[i], "-i" ) )
      return argv[i+1];
  return NULL;
} /*InputFilename*/

void SetWindowTitle ( char *fn )
{
  char s[80];
  int  l;

  if ( (l = strlen ( fn )) > 65 )
    fn = &fn[l-65];
  sprintf ( s, "Aplikacja 1F: %s", fn );
  ProcessWorldRequest ( WMSG_SET_TITLE, (void*)s, NULL );
} /*SetWindowTitle*/

void InitMyWorld ( int argc, char *argv[], int width, int height )
{
  char   *fn;
  static GLfloat fg[4] = { 0.0, 0.0, 1.0, 1.0 };
  static GLfloat bk[4] = { 0.0, 0.0, 0.0, 0.0 };

  if ( !(fn = InputFilename ( argc, argv )) ) {
    printf ( "wywolaj tak: app1f -i plik.smf\n" );
    exit ( 0 );
  }
  LoadMyShaders ();
  LoadTextShaders ();
  TimerInit ();
  font = fonts[0] = NewFont18x10 ();
  fonts[1] = NewFont12x6 ();
  vptext = NewTextObject ( 60 );
  SetTextForeground ( fg );
  SetTextBackground ( bk );
  memset ( &trans, 0, sizeof(TransBl) );
  memset ( &light, 0, sizeof(LightBl) );
  trans.trbuf = NewUniformTransBlock ();
  light.lsbuf = NewUniformLightBlock ();
  ConstructSMFObject ( fn );
  InitViewMatrix ();
  SetupModelMatrix ( model_rot_axis, model_rot_angle );
  InitLights ();
  ResizeMyWorld ( width, height );
  SetWindowTitle ( fn );
} /*InitMyWorld*/

void ResizeMyWorld ( int width, int height )
{
  float lr;

  glViewport ( 0, 0, win_width = width, win_height = height );
  SetupTextFrame ( width, height );
  lr = 0.5533*(float)width/(float)height;  /* przyjmujemy aspekt rowny 1 */
  M4x4Frustumf ( trans.pm, NULL, left = -lr, right = lr,
                 bottom = -0.5533, top = 0.5533, near = 5.0, far = 15.0 );
  LoadVPMatrix ( &trans );
  NotifyViewerPos ();
  ExitIfGLError ( "ResizeMyWorld" );
} /*ResizeMyWorld*/

void RedrawMyWorld ( char showpos )
{
  glClearColor ( 1.0, 1.0, 1.0, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  if ( showpos )
    DisplayTextObject ( vptext );
  glEnable ( GL_DEPTH_TEST );
  DrawSMFObject ( option );
  glFlush ();
  glUseProgram ( 0 );
} /*RedrawMyWorld*/

void DeleteMyWorld ( void )
{
  int i;

  glUseProgram ( 0 );
  glDeleteProgram ( program_id[0] );
  glDeleteProgram ( program_id[1] );
  glDeleteBuffers ( 1, &trans.trbuf );
  glDeleteBuffers ( 1, &light.lsbuf );
  glDeleteVertexArrays ( 1, &smf_vao );
  glDeleteBuffers ( 2, smf_vbo );
  DeleteTextObject ( vptext );
  for ( i = 0; i < 2; i++ )
    DeleteFontObject ( fonts[i] );
  DeleteEmptyVAO ();
#ifdef DEBUG_BUFFERS_ALLOCATION
  DumpBufferIdentifiers ();
#endif
  ExitIfGLError ( "DeleteMyWorld" );
} /*Cleanup*/

char ProcessCharCommand ( char charcode )
{
  int oldoption;

  oldoption = option;
  switch ( toupper ( charcode ) ) {
case 'L': enlight = !enlight;
    return true;
case 'M':
    font = font == fonts[0] ? fonts[1] : fonts[0];
    NotifyViewerPos ();
    return true;
case 'W': option = 0;  break;  /* przelaczamy na wierzcholki */
case 'K': option = 1;  break;  /* przelaczamy na krawedzie */
case 'S': option = 2;  break;  /* przelaczamy na sciany */
 default:
    return false;              /* ignorujemy wszystkie inne klawisze */
  }
  return option != oldoption;
} /*ProcessCharCommand*/

char MoveOn ( void )
{
  if ( (model_rot_angle += ANGULAR_VELOCITY * TimerTocTic ()) >= PI )
    model_rot_angle -= 2.0*PI;
  SetupModelMatrix ( model_rot_axis, model_rot_angle );
  return true;
} /*MoveOn*/

