#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "../utilities/linkage.h"
#include "lights.h"
#include "trans.h"
#include "../utilities/mygltext.h"
#include "app1eproc.h"
#include "app1eklinkage.h"

my_object sunplanete[NOBJECTS];

static char KLInit ( kl_linkage *lkg, kl_object *obj )
{
  static const int lkn[3] = {1, 4, 5};
  int on;

  on = obj - lkg->obj;
  kl_NewObjRef ( lkg, lkn[on], on, 0, NULL );
  return true;
} /*KLInit*/

static void KLTransform ( kl_linkage *lkg, kl_object *obj,
                          int refn, GLfloat *tr, int nv, int *vn )
{
  my_object *sp;

  sp = (my_object*)obj->usrdata;
  memcpy ( sp->mtr, tr, 16*sizeof(GLfloat) );
} /*KLTransform*/

static void KLRedraw ( kl_linkage *lkg, kl_object *obj )
{
  my_object *sp;

  sp = (my_object*)obj->usrdata;
  LoadMMatrix ( &trans, sp->mtr );
  DrawTessIcos ( sp->prog, sp->tl, sp->cs, sp->colour );
} /*KLRedraw*/

kl_linkage *ConstructMyLinkage ( void )
{
  kl_linkage *lkg;
  int        l[NLINKS], j[NJOINTS];
  GLfloat    tr[16];
  int        i;

  if ( (lkg = kl_NewLinkage ( NOBJECTS, NLINKS, NOBJREFS,
                              NJOINTS, NJOINTS, NULL )) ) {
    for ( i = 0; i < NLINKS; i++ )
      l[i] = kl_NewLink ( lkg );
    M4x4Scalef ( tr, RS, RS, RS );
    kl_NewObject ( lkg, 0, 3, 0, tr, (void*)&sunplanete[0],
                   KLInit, KLTransform, NULL, KLRedraw, NULL );
    M4x4Scalef ( tr, RE, RE, RE );
    kl_NewObject ( lkg, 0, 3, 0, tr, (void*)&sunplanete[1],
                   KLInit, KLTransform, NULL, KLRedraw, NULL );
    M4x4Scalef ( tr, RM, RM, RM );
    kl_NewObject ( lkg, 0, 3, 0, tr, (void*)&sunplanete[2],
                   KLInit, KLTransform, NULL, KLRedraw, NULL );
    j[0] = kl_NewJoint ( lkg, l[0], l[1], KL_ART_ROT_Z, 0 );
    j[1] = kl_NewJoint ( lkg, l[0], l[2], KL_ART_ROT_Z, 1 );
    j[2] = kl_NewJoint ( lkg, l[2], l[3], KL_ART_ROT_Z, 2 );
    j[3] = kl_NewJoint ( lkg, l[3], l[4], KL_ART_ROT_Z, 3 );
    j[4] = kl_NewJoint ( lkg, l[3], l[5], KL_ART_ROT_Z, 4 );
    M4x4Translatef ( tr, ROE, 0.0, 0.0 );
    kl_SetJointBtr ( lkg, j[1], tr, false );
    M4x4RotateXf ( tr, -23.5*PI/180.0 );
    kl_SetJointFtr ( lkg, j[3], tr, true );
    M4x4RotateYf ( tr, 5.15*PI/180.0 );
    kl_SetJointFtr ( lkg, j[4], tr, false );
    M4x4Translatef ( tr, ROM, 0.0, 0.0 );
    kl_SetJointBtr ( lkg, j[4], tr, false );
  }
  return lkg;
} /*ConstructMyLinkage*/

void ArticulateMyLinkage ( kl_linkage *lkg )
{
  phase += speed * TimerTocTic ();
  lkg->artp[0] = Mod2PI ( phase/TS );
  lkg->artp[2] = -(lkg->artp[1] = Mod2PI ( phase/TEY ));
  lkg->artp[3] = Mod2PI ( phase/TE );
  lkg->artp[4] = Mod2PI ( phase/TM );
  kl_Articulate ( lkg );
} /*ArticulateMyLinkage*/

