#version 420

in FVertex {
  vec3 Colour;
  vec3 Position;
  vec3 Normal, TNormal;
} In;

out vec4 out_Colour;

uniform TransBlock {
  mat4 mm, mmti, vm, pm, vpm;
  vec4 eyepos;
} trb;

#define AGamma(colour) pow ( colour, vec3(256.0/563.0) )

void main ( void )
{
  vec3  d;
  float r, g, b, f;

  d = normalize ( trb.eyepos.xyz - In.Position );
  f = 0.25+0.75*dot ( d, normalize ( In.Normal ) );
  r = 0.9+0.1*sin ( 100.0*In.Colour.r*In.Colour.g );
  g = 1.5*r-0.5;
  b = 0.5+0.1*cos ( 20.0*(In.Colour.b+In.Colour.r) );
  r = min ( 2.0*r, 1.0 );  g = min ( 2.0*g, 1.0 );
  out_Colour = vec4 ( AGamma ( f*vec3(r, g, b) ), 1.0 );
} /*main*/
