
/*#define DEBUG_BUFFERS_ALLOCATION*/

/* ////////////////////////////////////////////////////////////////////////// */
#ifdef DEBUG_BUFFERS_ALLOCATION 
#ifdef USE_GL3W
#define t_glGenBuffers    gl3w_glGenBuffers
#define t_glDeleteBuffers gl3w_glDeleteBuffers
#else
#ifdef USE_GLAD
#define t_glGenBuffers    glad_glGenBuffers
#define t_glDeleteBuffers glad_glDeleteBuffers
#else
#error "use glad or gl3w"
#endif
#endif

void traceglGenBuffers ( GLsizei n, GLuint *buffers, char *file, int line );
#undef glGenBuffers
#define glGenBuffers(n,b) {\
  t_glGenBuffers ( n, b );\
  traceglGenBuffers ( n, b, __FILE__, __LINE__ );\
}

void traceglDeleteBuffers ( GLsizei n, GLuint *buffers, char *file, int line );
#undef glDeleteBuffers
#define glDeleteBuffers(n,b) {\
  traceglDeleteBuffers ( n, b, __FILE__, __LINE__ );\
  t_glDeleteBuffers ( n, b );\
}

void DumpBufferIdentifiers ( void );
#endif

