#version 420

layout(triangles,equal_spacing) in;

in vec3 TCColour[];

layout(location=0) out vec3 TEColour;
layout(location=1) out vec3 Normal;

uniform TransBlock {
  mat4 mm, mmti, vm, pm, vpm;
  vec4 eyepos;
} trb;

void main ( void )
{
  float s, t, u;
  vec4  vert;

  s = gl_TessCoord.x;  t = gl_TessCoord.y;  u = gl_TessCoord.z;
  vert = s*gl_in[0].gl_Position + t*gl_in[1].gl_Position + u*gl_in[2].gl_Position;
  vert.xyz = normalize ( vert.xyz );  vert.w = 1.0;
  gl_Position = trb.vpm * (trb.mm * vert);
  TEColour = s*TCColour[0] + t*TCColour[1] + u*TCColour[2];
  Normal = vec3(0.0);
} /*main*/
