#version 420

layout(isolines,equal_spacing) in;

in vec3 TCColour[];

layout(location=0) out vec3 TEColour;
layout(location=1) out vec3 Normal;

uniform TransBlock {
  mat4 mm, mmti, vm, pm, vpm;
  vec4 eyepos;
} trb;

void main ( void )
{
  float t, t1;
  vec4  vert;

  t = gl_TessCoord.x;  t1 = 1.0-t;
  vert = t1*gl_in[0].gl_Position + t*gl_in[1].gl_Position;
  vert.xyz = normalize ( vert.xyz );  vert.w = 1.0;
  gl_Position = trb.vpm * (trb.mm * vert);
  TEColour = t1*TCColour[0] + t*TCColour[1];
  Normal = vec3(0.0);
} /*main*/
