#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "lights.h"
#include "trans.h"
#include "app1b.h"
#include "app1bproc.h"

#define ANGULAR_VELOCITY (0.25*PI)

GLuint  program_id[2];
GLuint  icos_vao, icos_vbo[3];
int     option = 2;
char    enlight = true;
TransBl trans;
LightBl light;
int     win_width, win_height;
float   left, right, bottom, top, near, far;
float   model_rot_axis[3] = {0.0,1.0,0.0};
double  model_rot_angle = 0.0;
float   viewer_rvec[3] = {1.0,0.0,0.0};
double  viewer_rangle = 0.0;
const float viewer_pos0[4] = {0.0,0.0,10.0,1.0};

void LoadMyShaders ( void )
{
  static const char *filename[] =
    { "app1b0.vert.glsl", "app1b0.frag.glsl",
      "app1b1.vert.glsl", "app1b1.geom.glsl", "app1b1.frag.glsl" };
  static const GLenum shtype[5] =
    { GL_VERTEX_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER };
  GLuint shader_id[5];
  int    i;

  for ( i = 0; i < 5; i++ )
    shader_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  program_id[0] = LinkShaderProgram ( 2, &shader_id[0], "0" );
  program_id[1] = LinkShaderProgram ( 3, &shader_id[2], "1" );
  GetAccessToTransBlockUniform ( program_id[1] );
  GetAccessToLightBlockUniform ( program_id[1] );
  AttachUniformTransBlockToBP ( program_id[0] );
  for ( i = 0; i < 5; i++ )
    glDeleteShader ( shader_id[i] );
  ExitIfGLError ( "LoadMyShaders" );
} /*LoadMyShaders*/

void SetupModelMatrix ( float axis[3], float angle )
{
  GLfloat mm[16];

  M4x4RotateVf ( mm, axis[0], axis[1], axis[2], angle );
  LoadMMatrix ( &trans, mm );
} /*SetupModelMatrix*/

void InitViewMatrix ( void )
{
  memcpy ( trans.eyepos, viewer_pos0, 4*sizeof(GLfloat) );
  M4x4Translatef ( trans.vm, -viewer_pos0[0], -viewer_pos0[1], -viewer_pos0[2] );
  LoadVPMatrix ( &trans );
} /*InitViewMatrix*/

void RotateViewer ( double delta_xi, double delta_eta )
{
  float   vi[3], lgt, vk[3];
  double  angi, angk;

  if ( delta_xi == 0.0 && delta_eta == 0.0 )
    return;  /* natychmiast uciekamy - nie chcemy dzielic przez 0 */
  vi[0] = (float)delta_eta*(top-bottom)/(float)win_height;
  vi[1] = (float)delta_xi*(right-left)/(float)win_width;
  vi[2] = 0.0;
  lgt = sqrt ( V3DotProductf ( vi, vi ) );
  vi[0] /= lgt;  vi[1] /= lgt;
  angi = -0.052359878;  /* -3 stopnie */
  V3CompRotationsf ( vk, &angk, viewer_rvec, viewer_rangle, vi, angi );
  memcpy ( viewer_rvec, vk, 3*sizeof(float) );
  viewer_rangle = angk;
  M4x4RotateVfv ( trans.vm, viewer_rvec, -viewer_rangle );
  M4x4MultMTVf ( trans.eyepos, trans.vm, viewer_pos0 );
  M4x4InvTranslateMfv ( trans.vm, viewer_pos0 );
  LoadVPMatrix ( &trans );
} /*RotateViewer*/

void ConstructIcosahedronVAO ( void )
{
#define A 0.52573115
#define B 0.85065085
  static const GLfloat vertpos[12][3] =
    {{ -A,0.0, -B},{  A,0.0, -B},{0.0, -B, -A},{ -B, -A,0.0},
     { -B,  A,0.0},{0.0,  B, -A},{  A,0.0,  B},{ -A,0.0,  B},
     {0.0, -B,  A},{  B, -A,0.0},{  B,  A,0.0},{0.0,  B,  A}};
  static const GLubyte vertcol[12][3] =
    {{255,0,0},{255,127,0},{255,255,0},{127,255,0},{0,255,0},{0,255,127},
     {0,255,255},{0,127,255},{0,0,255},{127,0,255},{255,0,255},{255,0,127}};
  static const GLubyte vertind[62] =
     { 0, 1, 2, 0, 3, 4, 0, 5, 1, 9, 2, 8, 3, /* lamana, od 0 */
       7, 4, 11, 5, 10, 9, 6, 8, 7, 6, 11, 7,
       1, 10, 6,                              /* lamana, od 25 */
       2, 3, 4, 5, 8, 9, 10, 11,              /* 4 odcinki, od 28 */
       0, 1, 2, 3, 4, 5, 1,                   /* wachlarz, od 36 */
       6, 7, 8, 9, 10, 11, 7,                 /* wachlarz, od 43  */
       1, 9, 2, 8, 3, 7, 4, 11, 5, 10, 1, 9}; /* tasma, od 50 */

  glGenVertexArrays ( 1, &icos_vao );
  glBindVertexArray ( icos_vao );
  glGenBuffers ( 3, icos_vbo );
  glBindBuffer ( GL_ARRAY_BUFFER, icos_vbo[0] );
  glBufferData ( GL_ARRAY_BUFFER,
                 12*3*sizeof(GLfloat), vertpos, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 0 );
  glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                          3*sizeof(GLfloat), (GLvoid*)0 );
  glBindBuffer ( GL_ARRAY_BUFFER, icos_vbo[1] );
  glBufferData ( GL_ARRAY_BUFFER,
                 12*3*sizeof(GLubyte), vertcol, GL_STATIC_DRAW );
  glEnableVertexAttribArray ( 1 );
  glVertexAttribPointer ( 1, 3, GL_UNSIGNED_BYTE, GL_TRUE,
                          3*sizeof(GLubyte), (GLvoid*)0 );
  glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, icos_vbo[2] );
  glBufferData ( GL_ELEMENT_ARRAY_BUFFER,
                 62*sizeof(GLubyte), vertind, GL_STATIC_DRAW );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "ConstructIcosahedronVAO" );
} /*ConstructIcosahedronVAO*/

void DrawIcosahedron ( int opt, char enlight )
{
  glProvokingVertex ( GL_FIRST_VERTEX_CONVENTION );
  glBindVertexArray ( icos_vao );
  switch ( opt ) {
case 0:    /* wierzcholki */
    glUseProgram ( program_id[0] );
    glPointSize ( 5.0 );
    glDrawArrays ( GL_POINTS, 0, 12 );
    break;
case 1:    /* krawedzie */
    glUseProgram ( program_id[0] );
    glDrawElements ( GL_LINE_STRIP, 25,
                     GL_UNSIGNED_BYTE, (GLvoid*)0 );
    glDrawElements ( GL_LINE_STRIP, 3,
                     GL_UNSIGNED_BYTE, (GLvoid*)(25*sizeof(GLubyte)) );
    glDrawElements ( GL_LINES, 8, 
                     GL_UNSIGNED_BYTE, (GLvoid*)(28*sizeof(GLubyte)) );
    break;
default:   /* sciany */
    glUseProgram ( program_id[enlight ? 1 : 0] );
    glDrawElements ( GL_TRIANGLE_FAN, 7,
                     GL_UNSIGNED_BYTE, (GLvoid*)(36*sizeof(GLubyte)) );
    glDrawElements ( GL_TRIANGLE_FAN, 7,
                     GL_UNSIGNED_BYTE, (GLvoid*)(43*sizeof(GLubyte)) );
    glDrawElements ( GL_TRIANGLE_STRIP, 12,
                     GL_UNSIGNED_BYTE, (GLvoid*)(50*sizeof(GLubyte)) );
    break;
  }
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawIcosahedron" );
} /*DrawIcosahedron*/

void InitLights ( void )
{
  GLfloat amb0[3] = { 0.1, 0.1, 0.15 };
  GLfloat dir0[3] = { 0.8, 0.8, 0.8 };
  GLfloat pos0[4] = { 0.0, 1.0, 1.0, 0.0 };
  GLfloat atn0[3] = { 1.0, 0.0, 0.0 };

  SetLightAmbient ( &light, 0, amb0 );
  SetLightDirect ( &light, 0, dir0 );
  SetLightPosition ( &light, 0, pos0 );
  SetLightAttenuation ( &light, 0, atn0 );
  SetLightOnOff ( &light, 0, 1 );
} /*InitLights*/

void InitMyWorld ( int argc, char *argv[], int width, int height )
{
  LoadMyShaders ();
  TimerInit ();
  memset ( &trans, 0, sizeof(TransBl) );
  memset ( &light, 0, sizeof(LightBl) );
  trans.trbuf = NewUniformTransBlock ();
  light.lsbuf = NewUniformLightBlock ();
  SetupModelMatrix ( model_rot_axis, model_rot_angle );
  InitViewMatrix ();
  ConstructIcosahedronVAO ();
  InitLights ();
  ResizeMyWorld ( width, height );
} /*InitMyWorld*/

void ResizeMyWorld ( int width, int height )
{
  float lr;

  glViewport ( 0, 0, win_width = width, win_height = height );
  lr = 0.5533*(float)width/(float)height;  /* przyjmujemy aspekt rowny 1 */
  M4x4Frustumf ( trans.pm, NULL, left = -lr, right = lr,
                 bottom = -0.5533, top = 0.5533, near = 5.0, far = 15.0 );
  
  LoadVPMatrix ( &trans );
  ExitIfGLError ( "ResizeMyWorld" );
} /*ResizeMyWorld*/

void RedrawMyWorld ( void )
{
  glClearColor ( 1.0, 1.0, 1.0, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  glEnable ( GL_DEPTH_TEST );
  DrawIcosahedron ( option, enlight );
  glFlush ();
  ExitIfGLError ( "RedrawMyWorld" );
} /*RedrawMyWorld*/

void DeleteMyWorld ( void )
{
  glUseProgram ( 0 );
  glDeleteProgram ( program_id[0] );
  glDeleteProgram ( program_id[1] );
  glDeleteBuffers ( 1, &trans.trbuf );
  glDeleteBuffers ( 1, &light.lsbuf );
  glDeleteVertexArrays ( 1, &icos_vao );
  glDeleteBuffers ( 3, icos_vbo );
#ifdef DEBUG_BUFFERS_ALLOCATION
  DumpBufferIdentifiers ();
#endif
  ExitIfGLError ( "DeleteMyWorld" );
} /*DeleteMyWorld*/

char ProcessCharCommand ( char charcode )
{
  int oldoption;

  oldoption = option;
  switch ( toupper ( charcode ) ) {
case 'L': enlight = !enlight;
    return true;
case 'W': option = 0;  break;  /* przelaczamy na wierzcholki */
case 'K': option = 1;  break;  /* przelaczamy na krawedzie */
case 'S': option = 2;  break;  /* przelaczamy na sciany */
 default:
    return false;              /* ignorujemy wszystkie inne klawisze */
  }
  return option != oldoption;
} /*ProcessCharCommand*/

char MoveOn ( void )
{
  if ( (model_rot_angle += ANGULAR_VELOCITY * TimerTocTic ()) >= PI )
    model_rot_angle -= 2.0*PI;
  SetupModelMatrix ( model_rot_axis, model_rot_angle );
  return true;
} /*MoveOn*/


