#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h" /* najpierw ten */
#include <GL/freeglut.h>  /* potem ten */

#include "../utilities/utilities.h"
#include "lights.h"
#include "trans.h"
#include "app1b.h"
#include "app1bproc.h"

#define STATE_NOTHING 0
#define STATE_TURNING 1

int  WindowHandle;
int  last_xi, last_eta;
int  app_state = STATE_NOTHING;
char animate = false;
int  opti = 0;

void ReshapeFunc ( int width, int height )
{
  ResizeMyWorld ( width, height );
  opti = 4;
} /*ReshapeFunc*/

void DisplayFunc ( void )
{
  if ( opti > 0 ) {
    opti --;
    glutPostWindowRedisplay ( WindowHandle );
  }
  else
    RedrawMyWorld ();
  glutSwapBuffers ();
} /*DisplayFunc*/

void MouseFunc ( int button, int state, int x, int y )
{
  switch ( app_state ) {
case STATE_NOTHING:
    if ( button == GLUT_LEFT_BUTTON && state == GLUT_DOWN ) {
      last_xi = x,  last_eta = y;
      app_state = STATE_TURNING;
    }
    break;
case STATE_TURNING:
    if ( button == GLUT_LEFT_BUTTON && state != GLUT_DOWN )
      app_state = STATE_NOTHING;
    break;
default:
    break;
  }
} /*MouseFunc*/

void MotionFunc ( int x, int y )
{
  switch ( app_state ) {
case STATE_TURNING:
    if ( x != last_xi || y != last_eta ) {
      RotateViewer ( x-last_xi, y-last_eta );
      last_xi = x,  last_eta = y;
      glutPostWindowRedisplay ( WindowHandle );
    }
    break;
default:
    break;
  }
} /*MotionFunc*/

void IdleFunc ( void )
{
  if ( MoveOn () )
    glutPostWindowRedisplay ( WindowHandle );
} /*IdleFunc*/

void ToggleAnimation ( void )
{
  if ( (animate = !animate) ) {
    TimerTic ();
    glutIdleFunc ( IdleFunc );
  }
  else
    glutIdleFunc ( NULL );
} /*ToggleAnimation*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glutDestroyWindow ( WindowHandle );
} /*Cleanup*/

void KeyboardFunc ( unsigned char key, int x, int y )
{
  switch ( key ) {
case 0x1B:            /* klawisz Esc - zatrzymanie programu */
    Cleanup ();
    glutLeaveMainLoop ();
    break;
case ' ':             /* wlaczamy albo wylaczamy animacje */
    ToggleAnimation ();
    break;
default:
    if ( ProcessCharCommand ( key ) )
      glutPostWindowRedisplay ( WindowHandle );
    break;
  }
} /*KeyboardFunc*/

void JoystickFunc ( unsigned int buttonmask, int x, int y, int z ) { }
void TimerFunc ( int value ) {  }

void Initialise ( int argc, char *argv[] )
{
  glutInit ( &argc, argv );
  glutInitContextVersion ( 2, 1 );
  glutInitContextFlags ( GLUT_FORWARD_COMPATIBLE );
  glutInitContextProfile ( GLUT_CORE_PROFILE );
  glutSetOption ( GLUT_ACTION_ON_WINDOW_CLOSE,
                  GLUT_ACTION_GLUTMAINLOOP_RETURNS );
  glutInitWindowSize ( 480, 360 );
  glutInitDisplayMode ( GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA );
  WindowHandle = glutCreateWindow ( "aplikacja 1B" );
  if ( WindowHandle < 1 ) {
    fprintf ( stderr, "Error: Could not create a window\n" );
    exit ( 1 );
  }
  GetGLProcAddresses ( APP1B_GL_MAJOR, APP1B_GL_MINOR );
  PrintGLVersion ();
  glutReshapeFunc ( ReshapeFunc );
  glutDisplayFunc ( DisplayFunc );
  glutKeyboardFunc ( KeyboardFunc );
  glutMouseFunc ( MouseFunc );
  glutMotionFunc ( MotionFunc );
  /*glutJoystickFunc ( JoystickFunc, 16 );*/
  /*glutTimerFunc ( 0, TimerFunc, 0 );*/
  InitMyWorld ( argc, argv, 480, 360 );
} /*Initialise*/

int main ( int argc, char *argv[] )
{
  Initialise ( argc, argv );
  glutMainLoop ();
  exit ( 0 );
} /*main*/

