#include <iostream>
#include <cstdio>
#include <vector>
#include <cmath>
#include <set>
#include <cassert>

#define REP(i,n) for(int i=0; i<(n); ++i)
#define REP2(i,n) for(i=0; i<(n); ++i)
#define REPD(i,n) for(int i=(n)-1; i>=0; --i)
#define FOR(i,a,b) for(int i=(a); i<=(b); ++i)
#define FORL(i,a,b) for(int i=(a); i<=(b); ++i)
#define FOR2(i,a,b) for(i=(a); i<=(b); ++i)
#define FORD(i,a,b) for(int i=(a); i>=(b); --i)
#define VAR(v,n) __typeof(n) v = n
#define FORE(i,v) for(VAR(i, (v).begin()); i!=(v).end(); ++i)
#define ALL(v) (v).begin(), (v).end()
#define PB push_back
#define MP(a,b) make_pair(a,b)
#define _INT(a) scanf("%d", &a)
#define INT(a) int a; _INT(a)
#define _VINT(v,n) do { (v).resize((n)); REP(i,(n)) { INT(j); (v)[i]=j; } } while(0)
#define VINT(v,n) vector<int> v; _VINT(v,n)
#define CHAR(a) char foo_##a[2]; scanf("%s", foo_##a); char a = foo_##a[0]

using namespace std;

int n, m;
#define MAXN 102
#define INF 0x3f

class Triple {
public:
    int v, a, b;
    Triple(int _v, int _a, int _b) : v(_v), a(_a), b(_b) {}
    bool operator < (const Triple X) const {
        if (v != X.v)
            return v < X.v;
        if (a != X.a)
            return a < X.a;
        return b < X.b;
    }
};

int dist[MAXN][MAXN];
int visi[MAXN][MAXN];
set <Triple> Q;

void init() {
    memset(dist, INF, sizeof(dist));
    memset(visi, INF, sizeof(dist));
    Q.clear();
}

bool read() {
    int ret;
    ret = scanf("%d%d", &n, &m);
    assert(ret == 2);
    
    if (n == 0 && m == 0)
        return false;
    
    FOR (i, 1, m) {
        int p, k;
        ret = scanf("%d%d", &p, &k);
        assert(ret == 2);
        
        assert(1 <= p && p <= n);
        assert(1 <= k && k <= n);

        assert(dist[p][k] != 1);        
        dist[p][k] = 1;
    }
    return true;
}

void floyd() {
    FOR (k, 1, n)
        FOR (i, 1, n)
            FOR (j, 1, n) {
                if (dist[i][j] > dist[i][k] + dist[k][j])
                    dist[i][j] = dist[i][k] + dist[k][j];           
            }   
    
/*
    FOR (i, 1, n) {
        FOR (j, 1, n) 
            cerr << dist[i][j] << " ";
        cerr << endl; 
    }
*/
}

int do_search() {
    int new_dist;
    Q.insert(Triple(1, 1, 1));
    visi[1][1] = 1;
        
    while (!Q.empty()) {
        Triple tmp = *Q.begin();
        Q.erase(Q.begin());
    
        if (tmp.v > visi[tmp.a][tmp.b])
            continue;
            
        FOR (i, 1, n) {
            //(tmp.a, tmp.b) -> (i, tmp.b)
            new_dist = tmp.v + (tmp.b != i ? 1 : 0);
            if (dist[tmp.a][i] == 1 && visi[i][tmp.b] > new_dist) {
                visi[i][tmp.b] = new_dist;
                Q.insert(Triple(new_dist, i, tmp.b));
            }
            
            //(tmp.a, tmp.b) -> (tmp.a, i)
            new_dist = tmp.v + (tmp.a != i ? 1 : 0);
            if (dist[i][tmp.b] == 1 && visi[tmp.a][i] > new_dist) {
                visi[tmp.a][i] = new_dist;
                Q.insert(Triple(new_dist, tmp.a, i));
            }
        }
            
        //(tmp.a, tmp.b) -> (tmp.b, tmp.a)
        new_dist = tmp.v + (dist[tmp.a][tmp.b] - 1);
        if (visi[tmp.b][tmp.a] > new_dist) {
            visi[tmp.b][tmp.a] = new_dist;
            Q.insert(Triple(new_dist, tmp.b, tmp.a));
        }
    }


    return visi[2][2];
}

bool solve_problem(int prob) {
    init();
    if (!read())
        return false;
    
    floyd();
    int result = do_search();
    printf("Network %d\n", prob);
    if (result > n)
        printf("IMPOSSIBLE\n");
    else
        printf("Minimum number of nodes = %d\n", result);
    printf("\n");
    
    return true;
}

int main() {
    int prob = 1;
    while (solve_problem(prob)) {
        prob++;
    }

    return 0;
}
