/* Problem J: Routing
 * Author: Tomasz Idziaszek
 */

#include <cstdio>
#include <vector>
#include <algorithm>
#include <queue>
using namespace std;
#define REP(i,n) for(int i=0;i<(n);++i)
#define FORE(i,c) for(__typeof((c).begin())i=(c).begin();i!=(c).end();++i)
typedef pair<int,int> PI;
#define MP make_pair

const int N=200, INF=1000000000;
int n,m,a,b,qe,qb;
vector<int> adj[N],adjT[N];
int d[N*N],sdist[N][N];

int main() {
   int test=0;
   while (scanf("%d%d",&n,&m),n||m) {
      /* Read graph, construct it and its transposition */
      REP(i,m) scanf("%d%d",&a,&b),adj[a-1].push_back(b-1),
	 adjT[b-1].push_back(a-1);

      /* Calculate distance function */
      REP(i,n) REP(j,n) sdist[i][j]=i==j?0:INF;
      REP(i,n) FORE(j,adj[i]) sdist[i][*j] = 1;
      REP(k,n) REP(i,n) REP(j,n) sdist[i][j] <?= sdist[i][k] + sdist[k][j];

      /* Dijkstra algorithm */
      REP(i,n*n) d[i]=INF;
      priority_queue<PI,vector<PI>,greater<PI> > q;
      q.push(MP(d[0]=1,0));
      while (q.size()) {
	 int dist = q.top().first;
	 int v = q.top().second; q.pop();
	 if (d[v] < dist) continue;
	 int v1 = v%n, v2 = v/n;
	 /* Edge of the first kind */
	 FORE(i,adj[v1]) {
	    int cost = *i != v2;
	    int nv = *i + v2*n;
	    if (d[nv] > dist+cost) {
	       d[nv] = dist+cost;
	       q.push(MP(d[nv],nv));
	    }
	 }
	 /* Edge of the second kind */
	 FORE(i,adjT[v2]) {
	    int cost = v1 != *i;
	    int nv = v1 + *i*n;
	    if (d[nv] > dist+cost) {
	       d[nv] = dist+cost;
	       q.push(MP(d[nv],nv));
	    }
	 }
	 /* Edge of the third kind */
	 if (v1 != v2) {
	    int cost = sdist[v1][v2]-1;
	    int nv = v2 + v1*n;
	    if (d[nv] > dist+cost) {
	       d[nv] = dist+cost;
	       q.push(MP(d[nv],nv));
	    }
	 }
      }

      /* Output the answer */
      printf("Network %d\n",++test);
      if (d[n+1]==1000000000) puts("IMPOSSIBLE");
      else printf("Minimum number of nodes = %d\n",d[n+1]);
      puts("");
      REP(i,n) adj[i].clear(),adjT[i].clear();
   }
}
