/*
 * Solution for the problem I from ACM 2006.
 *
 * Author: Janusz Parfieniuk 2006.12
 */


import java.util.HashMap;
import java.io.StreamTokenizer;
import java.io.InputStreamReader;
import java.io.BufferedReader;

public class sol2006i1 {

    static int lastUsedIndex = 0; // variable for names indexing
    /* 
     * solution is implementation of Floyd-Warshall algorithm
     */
    public static void main(String[] args) throws java.io.IOException 
        {
        // translation from person names to their indexes
        HashMap<String, Integer> namesMap = new HashMap<String, Integer>();
        
        String firstPerson, secondPerson; // for input purposes 
        
        final int NUMBER_OF_PERSONS = 50;
        final int INFINITE = NUMBER_OF_PERSONS+1;
        int noPersons, noRelations;
        int degree[][] = new int[NUMBER_OF_PERSONS][NUMBER_OF_PERSONS]; // persons adjacency matrix
        int firstPersonIndex, secondPersonIndex;
        int i, j, k, maxDegree, networkNumber=0;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                StreamTokenizer st = new StreamTokenizer(in);
        
        while (true) {
                        st.nextToken();
                noPersons = (int) st.nval; 
                        st.nextToken();
                noRelations = (int) st.nval; 

                        if( noPersons == 0 || noRelations == 0 ) break;
                
            networkNumber++;
            lastUsedIndex = 0;
            maxDegree = 0;
            for (i=0; i<noPersons; i++)
                    for (j=0; j<noPersons; j++)
                            degree[i][j] = INFINITE;
            for (i=0; i<noPersons; i++)
                    degree[i][i] = 0;

            namesMap.clear();
            // reading arguments
            for (i=0; i<noRelations; i++) {
                                        st.nextToken();
                    firstPerson = st.sval;
                                        st.nextToken();
                    secondPerson = st.sval;

                    firstPersonIndex = getPersonIndex(namesMap, firstPerson);
                    secondPersonIndex = getPersonIndex(namesMap, secondPerson);
                    degree[firstPersonIndex][secondPersonIndex] = 1;
                    degree[secondPersonIndex][firstPersonIndex] = 1;

            }

            // Floyd-Warshal
            for (k=0; k<noPersons; k++) 
                    for(i=0; i<noPersons; i++) 
                            for (j=0; j<noPersons; j++) 
                                    degree[i][j] = min(degree[i][j], degree[i][k] + degree[k][j]);

            // computation of solution
            for (i=0; i<noPersons; i++)  
                    for (j=0; j<noPersons; j++) 
                            if (maxDegree < degree[i][j])
                                    maxDegree = degree[i][j];

            System.out.print("Network " + networkNumber + ": ");
            if (maxDegree >= noPersons)
                    System.out.print("DISCONNECTED");
            else
                    System.out.print(maxDegree);
            System.out.println();
            System.out.println();
        }
    }
    
    /* 
     * fuction looks for personName in the map and returns value that
     * is assigned to that name, if association doesn't exist, assigns
     * it new value (denoted by lastIndex) 
     */
    static int getPersonIndex(HashMap<String, Integer> namesMap, String personName)
    {    
          if (namesMap.containsKey(personName)) 
              return namesMap.get(personName);
           namesMap.put(personName, lastUsedIndex);
        return lastUsedIndex++;
    }


    /* 
     * function returns lower of two passed integers 
     */
     static int min(int a, int b)
     {
         if (a < b)
             return a;
         return b;
     }

}
