/*
 * Solution for the problem I from ACM 2006.
 *
 * Author: Janusz Parfieniuk 2006.12
 */

#include <iostream>
#include <map>

using namespace std;

// maximal number of persons in the network
#define NUMBER_OF_PERSONS	50


/* 
 * fuction looks for personName in the map and returns value that
 * is assigned to that name, if association doesn't exist, assigns
 * it new value (denoted by lastIndex) 
 */
int getPersonIndex(map<string, int>& namesMap, string personName, int& lastIndex);


const int endOfLevel = -1;
const int endOfQueue = -1;
const int disconnectedGraph = -1;

/*
 * Class responsible for holding queue of vertex that
 * hasn't been visited yet.
 */
class personQueue {
	private:
		int queue[2*NUMBER_OF_PERSONS]; 
		/*  size of the queue is twice as big as
		 *  number of graph vertexes because we
		 *  need to denote end of levels (distances
		 *  from starting node).
		 */
		int inQueue[NUMBER_OF_PERSONS]; 
		/* table holds two values 0 and 1
		 * 0 - vertex isn't in the queue
		 * 1 - vertex has already been added to the queue
		 */
		int position; // actual position 
		int size; // total size of the queue
	public:
		void init(int noPersons);
		/* method initiates queue denoting that it would
		 * be holding up to noPersons vertexes (plus some
		 * guards to denote end of levels) 
		 */
		void add(int vertex);
		int getSize();
		int empty();
		int next();
		/* method returns next element from the queue */
};

/*
 * Class responsible for holding graph of relations between persons.
 */
class personGraph {
	private:
		int noVertexes;
		int edges[NUMBER_OF_PERSONS][NUMBER_OF_PERSONS];
		/* maximal number of persons is small so we can
		 * allow ourselves to hold relations in nxn 
		 * matrix 
		 */
		int edgesLengths[NUMBER_OF_PERSONS];
		personQueue pQueue;
		/* queue used for calculating degree of graph */
	public:
		void clear(int noPersons);
		/* method initiates graph and, for efficiency, clears
		 * only noPersons entries in edgesLengths table (wich is
		 * enough for graph up to noPersons)
		 */
		void addEdge(int a, int b);
		int checkDegree();
		/* method calculates degree of separation for graph and
		 * returns it, in case of disconnected graph returned
		 * value is "disconnectedGraph" 
		 */

};
		

/* algorithm used for solution computation is based on
 * starting bfs at each vertex (v)and calculating maximal distance
 * betwen v and another vertex from the graph
 */

int main()
{
	map<string, int> namesMap; // translation from person names to their indexes
	string firstPerson, secondPerson; // for input purposes 
	int noPersons, noRelations;
	int firstPersonIndex, secondPersonIndex, lastUsedIndex;
	int networkNumber=0, maxDegree;
	int i;
	personGraph relations; // graph representing relations
	
	cin >> noPersons;
	cin >> noRelations;
	
	while (noPersons != 0 || noRelations != 0) {
		relations.clear(noPersons);
		networkNumber++;
		lastUsedIndex = 0;
			
		namesMap.clear();
		// reading arguments
		for (i=0; i<noRelations; i++) {
			cin >> firstPerson;
			cin >> secondPerson;

			firstPersonIndex = getPersonIndex(namesMap, firstPerson, lastUsedIndex);
			secondPersonIndex = getPersonIndex(namesMap, secondPerson, lastUsedIndex);
			relations.addEdge(firstPersonIndex, secondPersonIndex);
		}
		
		maxDegree = relations.checkDegree();

		cout << "Network " << networkNumber << ": ";
		if (maxDegree == disconnectedGraph)
			cout << "DISCONNECTED";
		else
			cout << maxDegree;
		cout << endl << endl;
			

		cin >> noPersons;
		cin >> noRelations;
	}
	return 0;
}

void personQueue::init(int noPersons) 
{
	int i;
	for (i=0; i<noPersons; i++) 
		inQueue[i] = 0;
	position = 0;
	size = 0;
}

/* method adds a vertex to the queue, if vertex is
 * a guard then no occurence check is done (only
 * one guard can be between "position" and "size"
 */
void personQueue::add(int vertex)
{
	if (vertex != endOfLevel) { 
		if (inQueue[vertex] == 0) {
			inQueue[vertex] = 1;
			queue[size++] = vertex;
		}
	} else
		queue[size++] = endOfLevel;
}

int personQueue::next()
{
	if (position >= size)
		return endOfQueue;
	return queue[position++];
}

int personQueue::empty()
{
	return position == size;
}

int personQueue::getSize()
{
	return size;
}

void personGraph::clear(int noPersons) 
{
	int i;
	noVertexes = noPersons;
	for (i=0; i<noPersons; i++) 
		edgesLengths[i] = 0;
}

void personGraph::addEdge(int a, int b)
{
	edges[a][edgesLengths[a]++] = b;
	edges[b][edgesLengths[b]++] = a;
}


int personGraph::checkDegree()
{
	int i, j, maxDeg=0, deg, vertex;
	/* for every vertex in the graph, start
	 * bfs from that vertex
	 */
	for (i=0; i<noVertexes; i++) {
		pQueue.init(noVertexes);
		pQueue.add(i);
		pQueue.add(endOfLevel);
		deg = 0;
		while (!pQueue.empty()) {
			vertex = pQueue.next();
			if (vertex == endOfLevel) {
                          if (!pQueue.empty()) {
                            /* if endOfLevel has occured then it means that
                             * every vertex from following level has ben
                             * added and we have to add next guard
                             */
                            pQueue.add(endOfLevel);
                            deg++;
                          }
                        } else {
				for (j=0; j<edgesLengths[vertex]; j++) 
					pQueue.add(edges[vertex][j]);
			}
		}

		/* queue contains elements from graph plus guards, number
		 * of guards is counted in deg, substraction of size of
		 * elements and deg gives number of visited vertexes
		 */
		if (pQueue.getSize() - deg < noVertexes) 
			return disconnectedGraph;
		if (maxDeg < deg)
			maxDeg = deg;
	}
	return maxDeg;
}

int getPersonIndex(map<string, int>& namesMap, string personName, int& lastUsedIndex)
{
	if (namesMap.find(personName) == namesMap.end()) {
		namesMap[personName] = lastUsedIndex;
		return lastUsedIndex++;
	}
	return namesMap[personName];
}
